/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jnosql.communication.redis.keyvalue.DefaultRanking;
import org.eclipse.jnosql.communication.redis.keyvalue.Ranking;
import org.eclipse.jnosql.communication.redis.keyvalue.SortedSet;
import redis.clients.jedis.Jedis;

class DefaultSortedSet
implements SortedSet {
    private static final int LAST_ELEMENT = -1;
    private String key;
    private Jedis jedis;

    DefaultSortedSet(Jedis jedis, String keyspace) {
        Objects.requireNonNull(jedis, "jedis is required");
        Objects.requireNonNull(keyspace, "keyspace is required");
        this.key = keyspace;
        this.jedis = jedis;
    }

    @Override
    public void add(String member, Number value) throws NullPointerException {
        Objects.requireNonNull(member, "member is required");
        Objects.requireNonNull(value, "value is required");
        this.jedis.zadd(this.key, value.doubleValue(), member);
    }

    @Override
    public void add(Ranking ranking) throws NullPointerException {
        Objects.requireNonNull(ranking, "ranking is required");
        this.jedis.zadd(this.key, ranking.getPoints().doubleValue(), ranking.getMember());
    }

    @Override
    public Number increment(String member, Number value) throws NullPointerException {
        Objects.requireNonNull(member, "member is required");
        Objects.requireNonNull(value, "value is required");
        return this.jedis.zincrby(this.key, value.doubleValue(), member);
    }

    @Override
    public Number decrement(String member, Number value) throws NullPointerException {
        Objects.requireNonNull(member, "member is required");
        Objects.requireNonNull(value, "value is required");
        return this.increment(member, -value.longValue());
    }

    @Override
    public void remove(String member) throws NullPointerException {
        this.jedis.zrem(this.key, new String[]{member});
    }

    @Override
    public int size() {
        return (int)this.jedis.zcard(this.key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void delete() {
        this.jedis.del(this.key);
    }

    @Override
    public void expire(Duration ttl) throws NullPointerException {
        Objects.requireNonNull(ttl, "ttl is required");
        this.jedis.expire(this.key, (long)((int)ttl.getSeconds()));
    }

    @Override
    public void persist() {
        this.jedis.persist(this.key);
    }

    @Override
    public List<Ranking> range(long start, long end) {
        return this.jedis.zrangeWithScores(this.key, start, end).stream().map(t -> new DefaultRanking(t.getElement(), t.getScore())).collect(Collectors.toList());
    }

    @Override
    public List<Ranking> revRange(long start, long end) {
        return this.jedis.zrevrangeWithScores(this.key, start, end).stream().map(t -> new DefaultRanking(t.getElement(), t.getScore())).collect(Collectors.toList());
    }

    @Override
    public List<Ranking> getRanking() {
        return this.range(0L, -1L);
    }

    @Override
    public List<Ranking> getRevRanking() {
        return this.revRange(0L, -1L);
    }

    @Override
    public void clear() {
        this.jedis.del(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultSortedSet)) {
            return false;
        }
        DefaultSortedSet that = (DefaultSortedSet)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SortedSet{");
        sb.append("key='").append(this.key).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

