/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import jakarta.nosql.Value;
import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.keyvalue.KeyValueEntity;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.json.bind.Jsonb;
import org.eclipse.jnosql.communication.driver.ValueJSON;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisUtils;
import redis.clients.jedis.Jedis;

public class RedisBucketManager
implements BucketManager {
    private final String nameSpace;
    private final Jsonb jsonB;
    private final Jedis jedis;

    RedisBucketManager(String nameSpace, Jsonb provider, Jedis jedis) {
        this.nameSpace = nameSpace;
        this.jsonB = provider;
        this.jedis = jedis;
    }

    public String getName() {
        return this.nameSpace;
    }

    public <K, V> void put(K key, V value) throws NullPointerException {
        Objects.requireNonNull(value, "Value is required");
        Objects.requireNonNull(key, "key is required");
        String valideKey = RedisUtils.createKeyWithNameSpace(key.toString(), this.nameSpace);
        this.jedis.set(valideKey, this.jsonB.toJson(value));
    }

    public void put(KeyValueEntity entity) throws NullPointerException {
        this.put(entity.getKey(), entity.getValue());
    }

    public void put(KeyValueEntity entity, Duration ttl) throws NullPointerException, UnsupportedOperationException {
        this.put(entity);
        String valideKey = RedisUtils.createKeyWithNameSpace(entity.getKey().toString(), this.nameSpace);
        this.jedis.expire(valideKey, (long)((int)ttl.getSeconds()));
    }

    public void put(Iterable<KeyValueEntity> entities) throws NullPointerException {
        StreamSupport.stream(entities.spliterator(), false).forEach(this::put);
    }

    public void put(Iterable<KeyValueEntity> entities, Duration ttl) throws NullPointerException, UnsupportedOperationException {
        StreamSupport.stream(entities.spliterator(), false).forEach(this::put);
        StreamSupport.stream(entities.spliterator(), false).map(KeyValueEntity::getKey).map(k -> RedisUtils.createKeyWithNameSpace(k.toString(), this.nameSpace)).forEach(k -> this.jedis.expire(k, (long)((int)ttl.getSeconds())));
    }

    public <K> Optional<Value> get(K key) throws NullPointerException {
        String value = this.jedis.get(RedisUtils.createKeyWithNameSpace(key.toString(), this.nameSpace));
        if (value != null && !value.isEmpty()) {
            return Optional.of(ValueJSON.of((String)value));
        }
        return Optional.empty();
    }

    public <K> Iterable<Value> get(Iterable<K> keys) throws NullPointerException {
        return StreamSupport.stream(keys.spliterator(), false).map(k -> this.jedis.get(RedisUtils.createKeyWithNameSpace(k.toString(), this.nameSpace))).filter(value -> value != null && !value.isEmpty()).map(ValueJSON::of).collect(Collectors.toList());
    }

    public <K> void delete(K key) {
        this.jedis.del(RedisUtils.createKeyWithNameSpace(key.toString(), this.nameSpace));
    }

    public <K> void delete(Iterable<K> keys) {
        StreamSupport.stream(keys.spliterator(), false).forEach(this::delete);
    }

    public void close() {
        this.jedis.close();
    }
}

