/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.json.bind.Jsonb;
import org.eclipse.jnosql.communication.driver.JsonbSupplier;
import redis.clients.jedis.Jedis;

abstract class RedisCollection<T>
implements Collection<T> {
    protected static final Jsonb JSONB = (Jsonb)JsonbSupplier.getInstance().get();
    protected final Class<T> clazz;
    protected final String keyWithNameSpace;
    protected final Jedis jedis;
    protected final boolean isString;

    RedisCollection(Jedis jedis, Class<T> clazz, String keyWithNameSpace) {
        this.clazz = clazz;
        this.keyWithNameSpace = keyWithNameSpace;
        this.jedis = jedis;
        this.isString = String.class.equals(clazz);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Objects.requireNonNull(c);
        for (T bean : c) {
            if (bean == null) continue;
            this.add(bean);
        }
        return true;
    }

    @Override
    public int size() {
        return (int)this.jedis.llen(this.keyWithNameSpace);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<T> iterator() {
        return this.toArrayList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.toArrayList().toArray(a);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Use add all instead");
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        Objects.requireNonNull(elements);
        boolean containsAll = true;
        for (Object element : elements) {
            if (this.contains(element)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        Objects.requireNonNull(elements);
        boolean result = false;
        for (Object element : elements) {
            if (!this.remove(element)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (!this.clazz.isInstance(o)) {
            throw new ClassCastException("The object required is " + this.clazz.getName());
        }
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    protected T remove(int index) {
        String value = this.jedis.lindex(this.keyWithNameSpace, (long)index);
        if (value != null && !value.isEmpty()) {
            this.jedis.lrem(this.keyWithNameSpace, 1L, value);
            return this.serialize(value);
        }
        return null;
    }

    protected int indexOf(Object o) {
        if (!this.clazz.isInstance(o)) {
            return -1;
        }
        String value = this.serialize(o);
        for (int index = 0; index < this.size(); ++index) {
            String findedValue = this.jedis.lindex(this.keyWithNameSpace, (long)index);
            if (!value.equals(findedValue)) continue;
            return index;
        }
        return -1;
    }

    protected List<T> toArrayList() {
        ArrayList<T> list = new ArrayList<T>();
        for (int index = 0; index < this.size(); ++index) {
            T element = this.get(index);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    protected T get(int index) {
        String value = this.jedis.lindex(this.keyWithNameSpace, (long)index);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return this.serialize(value);
    }

    protected T serialize(String value) {
        if (this.isString) {
            return (T)value;
        }
        return (T)JSONB.fromJson(value, this.clazz);
    }

    protected String serialize(Object value) {
        if (value instanceof String) {
            return value.toString();
        }
        return JSONB.toJson(value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.keyWithNameSpace);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (RedisCollection.class.isInstance(obj)) {
            RedisCollection otherRedis = (RedisCollection)RedisCollection.class.cast(obj);
            return Objects.equals(otherRedis.keyWithNameSpace, this.keyWithNameSpace);
        }
        return false;
    }
}

