/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import jakarta.nosql.Configurations;
import jakarta.nosql.Settings;
import jakarta.nosql.keyvalue.KeyValueConfiguration;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.jnosql.communication.redis.keyvalue.DefaultRedisBucketManagerFactory;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisBucketManagerFactory;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisConfigurations;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public final class RedisConfiguration
implements KeyValueConfiguration {
    private static final int DEFAULT_PORT = 6379;
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final int DEFAULT_DATABASE = 0;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_MAX_TOTAL = 1000;
    private static final int DEFAULT_MAX_IDLE = 10;
    private static final int DEFAULT_MIN_IDLE = 1;
    private static final int DEFAULT_MAX_WAIT_MILLIS = 3000;

    public RedisBucketManagerFactory getManagerFactory(Map<String, String> configurations) {
        Objects.requireNonNull(configurations, "configurations is required");
        Settings.SettingsBuilder builder = Settings.builder();
        configurations.forEach((key, value) -> builder.put(key, value));
        return this.apply(builder.build());
    }

    public RedisBucketManagerFactory get(JedisPool jedisPool) {
        Objects.requireNonNull(jedisPool, "jedisPool is required");
        return new DefaultRedisBucketManagerFactory(jedisPool);
    }

    public RedisBucketManagerFactory apply(Settings settings) {
        Objects.requireNonNull(settings, "settings is required");
        JedisPoolConfig poolConfig = this.getJedisPoolConfig(settings);
        JedisPool jedisPool = this.getJedisPool(settings, poolConfig);
        return new DefaultRedisBucketManagerFactory(jedisPool);
    }

    private JedisPool getJedisPool(Settings settings, JedisPoolConfig poolConfig) {
        String localhost = settings.getSupplier(Arrays.asList(RedisConfigurations.HOST, Configurations.HOST)).map(Object::toString).orElse(DEFAULT_HOST);
        Integer port = settings.get((Supplier)RedisConfigurations.PORT).map(Object::toString).map(Integer::parseInt).orElse(6379);
        Integer timeout = settings.get((Supplier)RedisConfigurations.TIMEOUT).map(Object::toString).map(Integer::parseInt).orElse(2000);
        String password = settings.getSupplier(Arrays.asList(RedisConfigurations.PASSWORD, Configurations.PASSWORD)).map(Object::toString).orElse(null);
        Integer database = settings.get((Supplier)RedisConfigurations.DATABASE).map(Object::toString).map(Integer::parseInt).orElse(0);
        String clientName = settings.get((Supplier)RedisConfigurations.CLIENT_NAME).map(Object::toString).orElse(null);
        return new JedisPool((GenericObjectPoolConfig)poolConfig, localhost, port.intValue(), timeout.intValue(), password, database.intValue(), clientName);
    }

    private JedisPoolConfig getJedisPoolConfig(Settings settings) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(settings.get((Supplier)RedisConfigurations.MAX_TOTAL).map(Object::toString).map(Integer::parseInt).orElse(1000).intValue());
        poolConfig.setMaxIdle(settings.get((Supplier)RedisConfigurations.MAX_IDLE).map(Object::toString).map(Integer::parseInt).orElse(10).intValue());
        poolConfig.setMinIdle(settings.get((Supplier)RedisConfigurations.MIN_IDLE).map(Object::toString).map(Integer::parseInt).orElse(1).intValue());
        poolConfig.setMaxWaitMillis((long)settings.get((Supplier)RedisConfigurations.MAX_WAIT_MILLIS).map(Object::toString).map(Integer::parseInt).orElse(3000).intValue());
        return poolConfig;
    }
}

