/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisCollection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.args.ListPosition;

class RedisList<T>
extends RedisCollection<T>
implements List<T> {
    RedisList(Jedis jedis, Class<T> clazz, String keyWithNameSpace) {
        super(jedis, clazz, keyWithNameSpace);
    }

    @Override
    public int size() {
        return (int)this.jedis.llen(this.keyWithNameSpace);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.toArrayList().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.toArrayList().listIterator(index);
    }

    @Override
    public Iterator<T> iterator() {
        return this.toArrayList().iterator();
    }

    @Override
    public boolean add(T e) {
        Objects.requireNonNull(e);
        int index = this.size();
        if (index == 0) {
            if (this.isString) {
                this.jedis.lpush(this.keyWithNameSpace, new String[]{e.toString()});
            } else {
                this.jedis.lpush(this.keyWithNameSpace, new String[]{JSONB.toJson(e)});
            }
        } else {
            String previewValue = this.jedis.lindex(this.keyWithNameSpace, (long)(index - 1));
            if (this.isString) {
                this.jedis.linsert(this.keyWithNameSpace, ListPosition.AFTER, previewValue, e.toString());
            } else {
                this.jedis.linsert(this.keyWithNameSpace, ListPosition.AFTER, previewValue, JSONB.toJson(e));
            }
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> elements) {
        Objects.requireNonNull(elements);
        for (T element : elements) {
            this.add(index++, element);
        }
        return true;
    }

    @Override
    public void clear() {
        this.jedis.del(this.keyWithNameSpace);
    }

    @Override
    public T get(int index) {
        return super.get(index);
    }

    @Override
    public T set(int index, T element) {
        Objects.requireNonNull(element);
        if (this.isString) {
            this.jedis.lset(this.keyWithNameSpace, (long)index, element.toString());
        } else {
            this.jedis.lset(this.keyWithNameSpace, (long)index, JSONB.toJson(element));
        }
        return element;
    }

    @Override
    public void add(int index, T element) {
        Objects.requireNonNull(element);
        String previewValue = this.jedis.lindex(this.keyWithNameSpace, (long)index);
        if (previewValue != null && !previewValue.isEmpty()) {
            if (this.isString) {
                this.jedis.linsert(this.keyWithNameSpace, ListPosition.BEFORE, previewValue, element.toString());
            } else {
                this.jedis.linsert(this.keyWithNameSpace, ListPosition.BEFORE, previewValue, JSONB.toJson(element));
            }
        } else {
            this.add(element);
        }
    }

    @Override
    public T remove(int index) {
        return super.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return super.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        Objects.requireNonNull(o);
        String value = this.serialize(o);
        for (int index = this.size(); index > 0; --index) {
            String findedValue = this.jedis.lindex(this.keyWithNameSpace, (long)index);
            if (!value.equals(findedValue)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        ArrayList<Object> subList = new ArrayList<Object>();
        List elements = this.jedis.lrange(this.keyWithNameSpace, (long)fromIndex, (long)toIndex);
        for (String element : elements) {
            if (this.isString) {
                subList.add(element);
                continue;
            }
            subList.add(JSONB.fromJson(element, this.clazz));
        }
        return subList;
    }
}

