/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.bind.Jsonb;
import org.eclipse.jnosql.communication.driver.JsonbSupplier;
import redis.clients.jedis.Jedis;

class RedisMap<K, V>
implements Map<K, V> {
    protected static final Jsonb JSONB = (Jsonb)JsonbSupplier.getInstance().get();
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final String nameSpace;
    private final Jedis jedis;
    private final boolean isKeyString;
    private final boolean isValueString;

    RedisMap(Jedis jedis, Class<K> keyValue, Class<V> valueClass, String keyWithNameSpace) {
        this.keyClass = keyValue;
        this.valueClass = valueClass;
        this.nameSpace = keyWithNameSpace;
        this.jedis = jedis;
        this.isKeyString = String.class.equals(this.keyClass);
        this.isValueString = String.class.equals(valueClass);
    }

    @Override
    public int size() {
        return this.jedis.hgetAll(this.nameSpace).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        Objects.requireNonNull(key, "key is required");
        if (this.isKeyString) {
            return this.jedis.hexists(this.nameSpace, key.toString());
        }
        return this.jedis.hexists(this.nameSpace, JSONB.toJson(key));
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        String valueString = this.isValueString ? value.toString() : JSONB.toJson(value);
        Map<String, String> map = this.createRedisMap();
        return map.containsValue(valueString);
    }

    @Override
    public V get(Object key) {
        Objects.requireNonNull(key, "Key is required");
        String value = this.jedis.hget(this.nameSpace, JSONB.toJson(key));
        value = this.isKeyString ? this.jedis.hget(this.nameSpace, key.toString()) : this.jedis.hget(this.nameSpace, JSONB.toJson(key));
        if (value != null && !value.isEmpty()) {
            if (this.isValueString) {
                return (V)value;
            }
            return (V)JSONB.fromJson(value, this.valueClass);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(value, "Value is required");
        Objects.requireNonNull(value, "Key is required");
        String keyJson = this.isKeyString ? key.toString() : JSONB.toJson(key);
        String valueJSON = this.isValueString ? value.toString() : JSONB.toJson(value);
        this.jedis.hset(this.nameSpace, keyJson, valueJSON);
        return value;
    }

    @Override
    public V remove(Object key) {
        Objects.requireNonNull(key, "Key is required");
        V value = this.get(key);
        if (value != null) {
            if (this.isKeyString) {
                this.jedis.hdel(this.nameSpace, new String[]{key.toString()});
            } else {
                this.jedis.hdel(this.nameSpace, new String[]{JSONB.toJson(key)});
            }
            return value;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Objects.requireNonNull(map, "map is required");
        for (K key : map.keySet()) {
            V value = map.get(key);
            if (value == null) continue;
            this.put(key, value);
        }
    }

    @Override
    public void clear() {
        this.jedis.del(this.nameSpace);
    }

    @Override
    public Set<K> keySet() {
        return this.createHashMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.createHashMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.createHashMap().entrySet();
    }

    private Map<String, String> createRedisMap() {
        Map map = this.jedis.hgetAll(this.nameSpace);
        return map;
    }

    private Map<K, V> createHashMap() {
        HashMap values = new HashMap();
        Map<String, String> redisMap = this.createRedisMap();
        Function<String, Object> keyFunction = k -> {
            if (this.isKeyString) {
                return k;
            }
            return JSONB.fromJson(k, this.keyClass);
        };
        Function<String, Object> valueFunction = k -> {
            if (this.isValueString) {
                return redisMap.get(k);
            }
            return JSONB.fromJson((String)redisMap.get(k), this.valueClass);
        };
        return redisMap.keySet().stream().collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RedisMap{");
        sb.append("keyClass=").append(this.keyClass);
        sb.append(", valueClass=").append(this.valueClass);
        sb.append(", nameSpace='").append(this.nameSpace).append('\'');
        sb.append(", jedis=").append(this.jedis);
        sb.append(", JsonB=").append(JSONB);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.nameSpace);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (RedisMap.class.isInstance(obj)) {
            RedisMap otherRedis = (RedisMap)RedisMap.class.cast(obj);
            return Objects.equals(otherRedis.nameSpace, this.nameSpace);
        }
        return false;
    }
}

