/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisCollection;
import redis.clients.jedis.Jedis;

class RedisQueue<T>
extends RedisCollection<T>
implements Queue<T> {
    RedisQueue(Jedis jedis, Class<T> clazz, String keyWithNameSpace) {
        super(jedis, clazz, keyWithNameSpace);
    }

    @Override
    public void clear() {
        this.jedis.del(this.keyWithNameSpace);
    }

    @Override
    public boolean add(T e) {
        Objects.requireNonNull(e);
        if (this.isString) {
            this.jedis.rpush(this.keyWithNameSpace, new String[]{e.toString()});
        } else {
            this.jedis.rpush(this.keyWithNameSpace, new String[]{JSONB.toJson(e)});
        }
        return true;
    }

    @Override
    public boolean offer(T e) {
        return this.add(e);
    }

    @Override
    public T remove() {
        T value = this.poll();
        if (value == null) {
            throw new NoSuchElementException("No element in Redis Queue");
        }
        return value;
    }

    @Override
    public T poll() {
        String value = this.jedis.lpop(this.keyWithNameSpace);
        if (value != null && !value.isEmpty()) {
            if (this.isString) {
                return (T)value;
            }
            return (T)JSONB.fromJson(value, this.clazz);
        }
        return null;
    }

    @Override
    public T element() {
        T value = this.peek();
        if (value == null) {
            throw new NoSuchElementException("No element in Redis Queue");
        }
        return value;
    }

    @Override
    public T peek() {
        int index = this.size();
        if (index == 0) {
            return null;
        }
        if (this.isString) {
            return (T)this.jedis.lindex(this.keyWithNameSpace, (long)index - 1L);
        }
        return (T)JSONB.fromJson(this.jedis.lindex(this.keyWithNameSpace, (long)index - 1L), this.clazz);
    }
}

