/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisCollection;
import redis.clients.jedis.Jedis;

class RedisSet<T>
extends RedisCollection<T>
implements Set<T> {
    RedisSet(Jedis jedis, Class<T> clazz, String keyWithNameSpace) {
        super(jedis, clazz, keyWithNameSpace);
    }

    @Override
    public boolean add(T e) {
        Objects.requireNonNull(e);
        if (this.isString) {
            this.jedis.sadd(this.keyWithNameSpace, new String[]{e.toString()});
        } else {
            this.jedis.sadd(this.keyWithNameSpace, new String[]{JSONB.toJson(e)});
        }
        return true;
    }

    @Override
    public void clear() {
        this.jedis.del(this.keyWithNameSpace);
    }

    @Override
    public int size() {
        return (int)this.jedis.scard(this.keyWithNameSpace);
    }

    @Override
    protected int indexOf(Object o) {
        Objects.requireNonNull(o);
        String find = this.serialize(o);
        Set values = this.jedis.smembers(this.keyWithNameSpace);
        int index = 0;
        for (String value : values) {
            if (value.contains(find)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    protected T remove(int index) {
        throw new UnsupportedOperationException("Remove with index is not supported on Redis Set");
    }

    @Override
    public boolean remove(Object o) {
        if (!this.clazz.isInstance(o)) {
            throw new ClassCastException("The object required is " + this.clazz.getName());
        }
        String find = this.serialize(o);
        Set values = this.jedis.smembers(this.keyWithNameSpace);
        for (String value : values) {
            if (!value.contains(find)) continue;
            this.jedis.srem(this.keyWithNameSpace, new String[]{value});
            return true;
        }
        return false;
    }

    @Override
    protected List<T> toArrayList() {
        Set redisValues = this.jedis.smembers(this.keyWithNameSpace);
        ArrayList<Object> list = new ArrayList<Object>();
        for (String redisValue : redisValues) {
            if (this.isString) {
                list.add(redisValue);
                continue;
            }
            list.add(JSONB.fromJson(redisValue, this.clazz));
        }
        return list;
    }
}

