/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.communication;

import com.arangodb.ArangoDB;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.bind.Jsonb;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.driver.JsonbSupplier;
import org.eclipse.jnosql.communication.driver.ValueJSON;
import org.eclipse.jnosql.communication.keyvalue.BucketManager;
import org.eclipse.jnosql.communication.keyvalue.KeyValueEntity;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBAccessor;

public class ArangoDBBucketManager
implements BucketManager,
ArangoDBAccessor {
    private static final String KEY = "_key";
    private static final String VALUE = "_value";
    private static final Function<JsonObject, String> TO_JSON = e -> e.getString(VALUE);
    private static final Jsonb JSONB = (Jsonb)JsonbSupplier.getInstance().get();
    private final ArangoDB arangoDB;
    private final String bucketName;
    private final String namespace;

    ArangoDBBucketManager(ArangoDB arangoDB, String bucketName, String namespace) {
        this.arangoDB = arangoDB;
        this.bucketName = bucketName;
        this.namespace = namespace;
    }

    public String name() {
        return this.bucketName;
    }

    public <K, V> void put(K key, V value) throws NullPointerException {
        Objects.requireNonNull(key, "Key is required");
        Objects.requireNonNull(value, "value is required");
        JsonObject jsonObject = Json.createObjectBuilder().add(KEY, key.toString()).add(VALUE, JSONB.toJson(value)).build();
        if (this.arangoDB.db(this.bucketName).collection(this.namespace).documentExists(key.toString()).booleanValue()) {
            this.arangoDB.db(this.bucketName).collection(this.namespace).deleteDocument(key.toString());
        }
        this.arangoDB.db(this.bucketName).collection(this.namespace).insertDocument((Object)jsonObject);
    }

    public void put(KeyValueEntity entity) throws NullPointerException {
        this.put(entity.key(), entity.value());
    }

    public void put(Iterable<KeyValueEntity> keyValueEntities) throws NullPointerException {
        keyValueEntities.forEach(this::put);
    }

    public <K> Optional<Value> get(K key) throws NullPointerException {
        Objects.requireNonNull(key, "Key is required");
        JsonObject entity = (JsonObject)this.arangoDB.db(this.bucketName).collection(this.namespace).getDocument(key.toString(), JsonObject.class);
        return Optional.ofNullable(entity).map(TO_JSON).map(ValueJSON::of);
    }

    public <K> Iterable<Value> get(Iterable<K> keys) throws NullPointerException {
        return StreamSupport.stream(keys.spliterator(), false).map(Object::toString).map(k -> (JsonObject)this.arangoDB.db(this.bucketName).collection(this.namespace).getDocument(k, JsonObject.class)).filter(Objects::nonNull).map(TO_JSON).map(ValueJSON::of).collect(Collectors.toList());
    }

    public <K> void delete(K key) throws NullPointerException {
        this.arangoDB.db(this.bucketName).collection(this.namespace).deleteDocument(key.toString());
    }

    public <K> void delete(Iterable<K> keys) throws NullPointerException {
        Objects.requireNonNull(keys, "Keys is required");
        this.arangoDB.db(this.bucketName).collection(this.namespace).deleteDocuments((Iterable)StreamSupport.stream(keys.spliterator(), false).map(Object::toString).collect(Collectors.toList()));
    }

    public void close() {
        this.arangoDB.shutdown();
    }

    public void put(Iterable<KeyValueEntity> keyValueEntities, Duration ttl) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("ArangoDB does not support TTL");
    }

    public void put(KeyValueEntity entity, Duration ttl) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("ArangoDB does not support TTL");
    }

    @Override
    public ArangoDB getArangoDB() {
        return this.arangoDB;
    }
}

