/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.communication;

import com.arangodb.ArangoDB;
import com.arangodb.entity.CollectionEntity;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.ValueUtil;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBException;

public final class ArangoDBUtil {
    public static final String KEY = "_key";
    public static final String ID = "_id";
    public static final String REV = "_rev";
    private static final Logger LOGGER = Logger.getLogger(ArangoDBUtil.class.getName());

    private ArangoDBUtil() {
    }

    static void checkDatabase(String database, ArangoDB arangoDB) {
        Objects.requireNonNull(database, "database is required");
        try {
            Collection databases = arangoDB.getAccessibleDatabases();
            if (!databases.contains(database)) {
                arangoDB.createDatabase(database);
            }
        }
        catch (ArangoDBException e) {
            LOGGER.log(Level.WARNING, "Failed to create database: " + database, (Throwable)((Object)e));
        }
    }

    public static void checkCollection(String bucketName, ArangoDB arangoDB, String namespace) {
        ArangoDBUtil.checkDatabase(bucketName, arangoDB);
        List<String> collections = arangoDB.db(bucketName).getCollections().stream().map(CollectionEntity::getName).toList();
        if (!collections.contains(namespace)) {
            arangoDB.db(bucketName).createCollection(namespace);
        }
    }

    static CommunicationEntity toEntity(JsonObject jsonObject) {
        List<Element> documents = ArangoDBUtil.toDocuments(jsonObject);
        String id = jsonObject.getString(ID);
        documents.add(Element.of((String)KEY, (Object)jsonObject.getString(KEY)));
        documents.add(Element.of((String)ID, (Object)id));
        documents.add(Element.of((String)REV, (Object)jsonObject.getString(REV)));
        String collection = id.split("/")[0];
        return CommunicationEntity.of((String)collection, documents);
    }

    static JsonObject toJsonObject(CommunicationEntity entity) {
        return ArangoDBUtil.toJsonObject(entity.elements());
    }

    private static List<Element> toDocuments(JsonObject object) {
        return object.entrySet().stream().map(it -> Element.of((String)((String)it.getKey()), (Object)ArangoDBUtil.toDocuments((JsonValue)it.getValue()))).collect(Collectors.toList());
    }

    private static List<?> toDocuments(JsonArray array) {
        return array.stream().map(ArangoDBUtil::toDocuments).toList();
    }

    private static Object toDocuments(JsonValue value) {
        return switch (value.getValueType()) {
            default -> throw new IncompatibleClassChangeError();
            case JsonValue.ValueType.OBJECT -> ArangoDBUtil.toDocuments(value.asJsonObject());
            case JsonValue.ValueType.ARRAY -> ArangoDBUtil.toDocuments(value.asJsonArray());
            case JsonValue.ValueType.STRING -> ((JsonString)value).getString();
            case JsonValue.ValueType.NUMBER -> ((JsonNumber)value).numberValue();
            case JsonValue.ValueType.TRUE -> true;
            case JsonValue.ValueType.FALSE -> false;
            case JsonValue.ValueType.NULL -> null;
        };
    }

    private static JsonObject toJsonObject(Iterable<Element> elements) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Element document : elements) {
            if (KEY.equals(document.name()) && Objects.isNull(document.get())) continue;
            Object value = ValueUtil.convert((Value)document.value());
            builder.add(document.name(), ArangoDBUtil.toJsonValue(value));
        }
        return builder.build();
    }

    private static JsonValue toJsonValue(Object value) {
        if (value instanceof Element) {
            Element document = (Element)value;
            return ArangoDBUtil.toJsonObject(Collections.singletonList(document));
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            if (ArangoDBUtil.isSubDocument(iterable)) {
                return ArangoDBUtil.toJsonObject(iterable);
            }
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (Object it : iterable) {
                builder.add(ArangoDBUtil.toJsonValue(it));
            }
            return builder.build();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry e : map.entrySet()) {
                builder.add((String)e.getKey(), ArangoDBUtil.toJsonValue(e.getValue()));
            }
            return builder.build();
        }
        if (Objects.isNull(value)) {
            return JsonValue.NULL;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Json.createValue((Number)number);
        }
        if (value instanceof String) {
            String string = (String)value;
            return Json.createValue((String)string);
        }
        if (Boolean.TRUE.equals(value)) {
            return JsonValue.TRUE;
        }
        if (Boolean.FALSE.equals(value)) {
            return JsonValue.FALSE;
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass());
    }

    private static boolean isSubDocument(Iterable<?> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).allMatch(Element.class::isInstance);
    }
}

