/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.communication;

import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.internal.ArangoErrors;
import jakarta.json.JsonObject;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.databases.arangodb.communication.AQLQueryResult;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBDocumentManager;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBUtil;
import org.eclipse.jnosql.databases.arangodb.communication.QueryAQLConverter;

class DefaultArangoDBDocumentManager
implements ArangoDBDocumentManager {
    private static final Logger LOGGER = Logger.getLogger(DefaultArangoDBDocumentManager.class.getName());
    public static final String KEY = "_key";
    public static final String ID = "_id";
    public static final String REV = "_rev";
    private final String database;
    private final ArangoDB arangoDB;

    DefaultArangoDBDocumentManager(String database, ArangoDB arangoDB) {
        this.database = database;
        this.arangoDB = arangoDB;
    }

    public String name() {
        return this.database;
    }

    public CommunicationEntity insert(CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        String collectionName = entity.name();
        this.checkCollection(collectionName);
        JsonObject jsonObject = ArangoDBUtil.toJsonObject(entity);
        DocumentCreateEntity arangoDocument = this.arangoDB.db(this.database).collection(collectionName).insertDocument((Object)jsonObject);
        this.updateEntity(entity, arangoDocument.getKey(), arangoDocument.getId(), arangoDocument.getRev());
        return entity;
    }

    public CommunicationEntity update(CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        String collectionName = entity.name();
        this.checkCollection(collectionName);
        entity.find(KEY, String.class).orElseThrow(() -> new IllegalArgumentException("The document does not provide the _key column"));
        JsonObject jsonObject = ArangoDBUtil.toJsonObject(entity);
        DocumentUpdateEntity arangoDocument = this.arangoDB.db(this.database).collection(collectionName).updateDocument(jsonObject.getString(KEY), (Object)jsonObject);
        this.updateEntity(entity, arangoDocument.getKey(), arangoDocument.getId(), arangoDocument.getRev());
        return entity;
    }

    public Iterable<CommunicationEntity> update(Iterable<CommunicationEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    public void delete(DeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        try {
            if (query.condition().isEmpty()) {
                AQLQueryResult delete = QueryAQLConverter.delete(query);
                this.arangoDB.db(this.database).query(delete.query(), BaseDocument.class);
                return;
            }
            AQLQueryResult delete = QueryAQLConverter.delete(query);
            this.arangoDB.db(this.database).query(delete.query(), BaseDocument.class, delete.values(), null);
        }
        catch (ArangoDBException exception) {
            if (ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND.equals(exception.getErrorNum())) {
                LOGGER.log(Level.FINEST, exception, () -> "An error to run query, that is related to delete a document collection that does not exist");
            }
            throw exception;
        }
    }

    public Stream<CommunicationEntity> select(SelectQuery query) throws NullPointerException {
        Objects.requireNonNull(query, "query is required");
        AQLQueryResult result = QueryAQLConverter.select(query);
        LOGGER.finest("Executing AQL: " + result.query());
        ArangoCursor documents = this.arangoDB.db(this.database).query(result.query(), JsonObject.class, result.values(), null);
        return StreamSupport.stream(documents.spliterator(), false).map(ArangoDBUtil::toEntity);
    }

    public long count(String documentCollection) {
        Objects.requireNonNull(documentCollection, "document collection is required");
        String aql = "RETURN LENGTH(" + documentCollection + ")";
        ArangoCursor query = this.arangoDB.db(this.database).query(aql, Object.class, Collections.emptyMap(), null);
        return StreamSupport.stream(query.spliterator(), false).findFirst().map(Number.class::cast).map(Number::longValue).orElse(0L);
    }

    @Override
    public Stream<CommunicationEntity> aql(String query, Map<String, Object> params) throws NullPointerException {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(params, "values is required");
        ArangoCursor result = this.arangoDB.db(this.database).query(query, JsonObject.class, params, null);
        return StreamSupport.stream(result.spliterator(), false).map(ArangoDBUtil::toEntity);
    }

    @Override
    public <T> Stream<T> aql(String query, Map<String, Object> params, Class<T> type) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(params, "values is required");
        Objects.requireNonNull(type, "typeClass is required");
        ArangoCursor result = this.arangoDB.db(this.database).query(query, type, params, null);
        return StreamSupport.stream(result.spliterator(), false);
    }

    @Override
    public <T> Stream<T> aql(String query, Class<T> type) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(type, "typeClass is required");
        ArangoCursor result = this.arangoDB.db(this.database).query(query, type, Collections.emptyMap(), null);
        return StreamSupport.stream(result.spliterator(), false);
    }

    public void close() {
        this.arangoDB.shutdown();
    }

    private void checkCollection(String collectionName) {
        ArangoDBUtil.checkCollection(this.database, this.arangoDB, collectionName);
    }

    public CommunicationEntity insert(CommunicationEntity entity, Duration ttl) {
        throw new UnsupportedOperationException("TTL is not supported on ArangoDB implementation");
    }

    public Iterable<CommunicationEntity> insert(Iterable<CommunicationEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    public Iterable<CommunicationEntity> insert(Iterable<CommunicationEntity> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(e -> this.insert((CommunicationEntity)e, ttl)).collect(Collectors.toList());
    }

    @Override
    public ArangoDB getArangoDB() {
        return this.arangoDB;
    }

    private void updateEntity(CommunicationEntity entity, String key, String id, String rev) {
        entity.add(Element.of((String)KEY, (Object)key));
        entity.add(Element.of((String)ID, (Object)id));
        entity.add(Element.of((String)REV, (Object)rev));
    }
}

