/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.communication;

import com.arangodb.serde.ArangoSerde;
import jakarta.json.bind.Jsonb;
import java.nio.charset.StandardCharsets;
import org.eclipse.jnosql.communication.driver.JsonbSupplier;

public class JsonbSerde
implements ArangoSerde {
    private final Jsonb jsonb;

    public JsonbSerde() {
        this((Jsonb)JsonbSupplier.getInstance().get());
    }

    public JsonbSerde(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public byte[] serialize(Object value) {
        return this.jsonb.toJson(value).getBytes(StandardCharsets.UTF_8);
    }

    public <T> T deserialize(byte[] content, Class<T> type) {
        return (T)this.jsonb.fromJson(new String(content, StandardCharsets.UTF_8), type);
    }
}

