/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.communication;

import jakarta.data.Direction;
import jakarta.data.Sort;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.ValueUtil;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.databases.arangodb.communication.AQLQueryResult;

final class QueryAQLConverter {
    private static final String FILTER = " FILTER ";
    private static final String LIMIT = " LIMIT ";
    private static final String IN = " IN ";
    private static final String SORT = " SORT ";
    private static final String REMOVE = " REMOVE ";
    private static final String RETURN = " RETURN ";
    private static final String SEPARATOR = " ";
    private static final String START_EXPRESSION = "(";
    private static final String END_EXPRESSION = ")";
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String EQUALS = " == ";
    private static final String GREATER_EQUALS_THAN = " >= ";
    private static final String GREATER_THAN = " > ";
    private static final String LESSER_THAN = " < ";
    private static final String LESSER_EQUALS_THAN = " <= ";
    private static final String LIKE = " LIKE ";
    private static final String NOT = " NOT ";
    private static final char PARAM_APPENDER = '@';

    private QueryAQLConverter() {
    }

    public static AQLQueryResult delete(DeleteQuery query) throws NullPointerException {
        return QueryAQLConverter.convert(query.name(), query.condition().orElse(null), Collections.emptyList(), 0L, 0L, REMOVE, true);
    }

    public static AQLQueryResult select(SelectQuery query) throws NullPointerException {
        return QueryAQLConverter.convert(query.name(), query.condition().orElse(null), query.sorts(), query.skip(), query.limit(), RETURN, false);
    }

    private static AQLQueryResult convert(String documentCollection, CriteriaCondition documentCondition, List<Sort<?>> sorts, long firstResult, long maxResult, String conclusion, boolean delete) {
        StringBuilder aql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        char entity = Character.toLowerCase(documentCollection.charAt(0));
        aql.append("FOR ").append(entity).append(IN).append(documentCollection);
        Optional.ofNullable(documentCondition).ifPresent(condition -> {
            aql.append(FILTER);
            QueryAQLConverter.definesCondition(condition, aql, params, entity, 0);
        });
        if (!sorts.isEmpty()) {
            QueryAQLConverter.sort(sorts, aql, entity);
        }
        if (firstResult > 0L && maxResult > 0L) {
            aql.append(LIMIT).append(firstResult).append(", ").append(maxResult);
        } else if (maxResult > 0L) {
            aql.append(LIMIT).append(maxResult);
        } else if (firstResult > 0L) {
            aql.append(LIMIT).append(firstResult).append(", null");
        }
        aql.append(conclusion).append(entity);
        if (delete) {
            aql.append(IN).append(documentCollection);
        }
        return new AQLQueryResult(aql.toString(), params);
    }

    private static void sort(List<Sort<?>> sorts, StringBuilder aql, char entity) {
        aql.append(SORT);
        String separator = SEPARATOR;
        for (Sort<?> sort : sorts) {
            aql.append(separator).append(entity).append('.').append(sort.property()).append(SEPARATOR).append(sort.isAscending() ? Direction.ASC : Direction.DESC);
            separator = " , ";
        }
    }

    private static void definesCondition(CriteriaCondition condition, StringBuilder aql, Map<String, Object> params, char entity, int counter) {
        Element document = condition.element();
        switch (condition.condition()) {
            case IN: {
                QueryAQLConverter.appendCondition(aql, params, entity, document, IN);
                return;
            }
            case EQUALS: {
                QueryAQLConverter.appendCondition(aql, params, entity, document, EQUALS);
                return;
            }
            case GREATER_EQUALS_THAN: {
                QueryAQLConverter.appendCondition(aql, params, entity, document, GREATER_EQUALS_THAN);
                return;
            }
            case GREATER_THAN: {
                QueryAQLConverter.appendCondition(aql, params, entity, document, GREATER_THAN);
                return;
            }
            case LESSER_THAN: {
                QueryAQLConverter.appendCondition(aql, params, entity, document, LESSER_THAN);
                return;
            }
            case LESSER_EQUALS_THAN: {
                QueryAQLConverter.appendCondition(aql, params, entity, document, LESSER_EQUALS_THAN);
                return;
            }
            case LIKE: {
                QueryAQLConverter.appendCondition(aql, params, entity, document, LIKE);
                return;
            }
            case AND: {
                for (CriteriaCondition dc : (List)document.get((TypeSupplier)new TypeReference<List<CriteriaCondition>>(){})) {
                    if (QueryAQLConverter.isFirstCondition(aql, counter)) {
                        aql.append(AND);
                    }
                    QueryAQLConverter.definesCondition(dc, aql, params, entity, ++counter);
                }
                return;
            }
            case OR: {
                for (CriteriaCondition dc : (List)document.get((TypeSupplier)new TypeReference<List<CriteriaCondition>>(){})) {
                    if (QueryAQLConverter.isFirstCondition(aql, counter)) {
                        aql.append(OR);
                    }
                    QueryAQLConverter.definesCondition(dc, aql, params, entity, ++counter);
                }
                return;
            }
            case NOT: {
                CriteriaCondition documentCondition = (CriteriaCondition)document.get(CriteriaCondition.class);
                aql.append(NOT);
                aql.append(START_EXPRESSION);
                QueryAQLConverter.definesCondition(documentCondition, aql, params, entity, ++counter);
                aql.append(END_EXPRESSION);
                return;
            }
        }
        throw new IllegalArgumentException("The condition does not support in AQL: " + condition.condition());
    }

    private static boolean isFirstCondition(StringBuilder aql, int count) {
        return count > 0 && !FILTER.equals(aql.substring(aql.length() - 8));
    }

    private static void appendCondition(StringBuilder aql, Map<String, Object> params, char entity, Element document, String condition) {
        String nameParam = QueryAQLConverter.getNameParam(document.name(), params);
        aql.append(SEPARATOR).append(entity).append('.').append(document.name()).append(condition).append('@').append(nameParam);
        if (IN.equals(condition)) {
            params.put(nameParam, ValueUtil.convertToList((Value)document.value()));
        } else {
            params.put(nameParam, document.get());
        }
    }

    private static String getNameParam(String name, Map<String, Object> params) {
        String parameter = QueryAQLConverter.getNameParam(name);
        Object paramName = parameter;
        int counter = 1;
        while (params.containsKey(paramName)) {
            paramName = parameter + "_" + counter;
        }
        return paramName;
    }

    private static String getNameParam(String name) {
        if ('_' == name.charAt(0)) {
            return name.substring(1);
        }
        return name;
    }
}

