/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.mapping;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jnosql.databases.arangodb.mapping.AQL;
import org.eclipse.jnosql.databases.arangodb.mapping.ArangoDBTemplate;
import org.eclipse.jnosql.databases.arangodb.mapping.ParamUtil;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.query.AbstractRepository;
import org.eclipse.jnosql.mapping.core.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.document.DocumentTemplate;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.query.AbstractSemiStructuredRepositoryProxy;
import org.eclipse.jnosql.mapping.semistructured.query.SemiStructuredRepositoryProxy;

class ArangoDBDocumentRepositoryProxy<T, K>
extends AbstractSemiStructuredRepositoryProxy<T, K> {
    private final Class<T> typeClass;
    private final ArangoDBTemplate template;
    private final AbstractRepository<?, ?> repository;
    private final Class<?> type;
    private final Converters converters;
    private final EntityMetadata entityMetadata;

    ArangoDBDocumentRepositoryProxy(ArangoDBTemplate template, Class<?> type, Converters converters, EntitiesMetadata entitiesMetadata) {
        this.template = template;
        this.typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(type.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.type = type;
        this.converters = converters;
        this.entityMetadata = entitiesMetadata.get(this.typeClass);
        this.repository = SemiStructuredRepositoryProxy.SemiStructuredRepository.of((SemiStructuredTemplate)template, (EntityMetadata)this.entityMetadata);
    }

    protected AbstractRepository repository() {
        return this.repository;
    }

    protected Class<?> repositoryType() {
        return this.type;
    }

    protected Converters converters() {
        return this.converters;
    }

    protected EntityMetadata entityMetadata() {
        return this.entityMetadata;
    }

    protected DocumentTemplate template() {
        return this.template;
    }

    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        AQL aql = method.getAnnotation(AQL.class);
        if (Objects.nonNull(aql)) {
            Map<String, Object> params = ParamUtil.getParams(args, method);
            Stream result = params.isEmpty() ? this.template.aql(aql.value(), Collections.emptyMap()) : this.template.aql(aql.value(), params);
            return DynamicReturn.builder().classSource(this.typeClass).methodSource(method).result(() -> result).singleResult((Supplier)DynamicReturn.toSingleResult((Method)method).apply(() -> result)).build().execute();
        }
        return super.invoke(instance, method, args);
    }
}

