/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.mapping;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBDocumentManager;
import org.eclipse.jnosql.databases.arangodb.mapping.ArangoDBTemplate;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.semistructured.AbstractSemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;
import org.eclipse.jnosql.mapping.semistructured.EventPersistManager;

@Typed(value={ArangoDBTemplate.class})
@ApplicationScoped
class DefaultArangoDBTemplate
extends AbstractSemiStructuredTemplate
implements ArangoDBTemplate {
    private final Instance<ArangoDBDocumentManager> manager;
    private final EntityConverter converter;
    private final EventPersistManager eventManager;
    private final EntitiesMetadata entities;
    private final Converters converters;

    @Inject
    DefaultArangoDBTemplate(Instance<ArangoDBDocumentManager> manager, EntityConverter converter, EventPersistManager eventManager, EntitiesMetadata entities, Converters converters) {
        this.manager = manager;
        this.converter = converter;
        this.eventManager = eventManager;
        this.entities = entities;
        this.converters = converters;
    }

    DefaultArangoDBTemplate() {
        this(null, null, null, null, null);
    }

    protected EntityConverter converter() {
        return this.converter;
    }

    protected DatabaseManager manager() {
        return (DatabaseManager)this.manager.get();
    }

    protected EventPersistManager eventManager() {
        return this.eventManager;
    }

    protected EntitiesMetadata entities() {
        return this.entities;
    }

    protected Converters converters() {
        return this.converters;
    }

    @Override
    public <T> Stream<T> aql(String query, Map<String, Object> params) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(params, "values is required");
        return ((ArangoDBDocumentManager)this.manager.get()).aql(query, params).map(arg_0 -> ((EntityConverter)this.converter).toEntity(arg_0)).map(d -> d);
    }

    @Override
    public <T> Stream<T> aql(String query, Map<String, Object> params, Class<T> type) {
        return ((ArangoDBDocumentManager)this.manager.get()).aql(query, params, type);
    }

    @Override
    public <T> Stream<T> aql(String query, Class<T> type) {
        return ((ArangoDBDocumentManager)this.manager.get()).aql(query, type);
    }
}

