/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.driver.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jnosql.communication.CommunicationException;
import org.eclipse.jnosql.communication.driver.attachment.EntityAttachment;

public class PathEntityAttachment
implements EntityAttachment {
    private final Path path;

    public PathEntityAttachment(Path path) {
        Objects.requireNonNull(path, "path cannot be null");
        if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path)) {
            throw new IllegalArgumentException("Path is not a readable file: " + path);
        }
        this.path = path;
    }

    @Override
    public String name() {
        return this.path.getFileName().toString();
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getContentType() {
        try {
            return Files.probeContentType(this.path);
        }
        catch (IOException e) {
            throw new CommunicationException("There is an error to load the content type", (Throwable)e);
        }
    }

    @Override
    public InputStream getData() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public long getLength() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

