/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.types.Binary;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.driver.ValueUtil;

final class MongoDBUtils {
    static final String ID_FIELD = "_id";
    private static final Function<Object, String> KEY_DOCUMENT = d -> MongoDBUtils.cast(d).name();
    private static final Function<Object, Object> VALUE_DOCUMENT = d -> MongoDBUtils.convert(MongoDBUtils.cast(d).value());

    private MongoDBUtils() {
    }

    static Document getDocument(DocumentEntity entity) {
        Document document = new Document();
        entity.documents().forEach(d -> document.append(d.name(), MongoDBUtils.convert(d.value())));
        return document;
    }

    private static Object convert(Value value) {
        Object val = ValueUtil.convert((Value)value);
        if (val instanceof org.eclipse.jnosql.communication.document.Document) {
            org.eclipse.jnosql.communication.document.Document subDocument = (org.eclipse.jnosql.communication.document.Document)val;
            Object converted = MongoDBUtils.convert(subDocument.value());
            return new Document(subDocument.name(), converted);
        }
        if (MongoDBUtils.isSudDocument(val)) {
            return MongoDBUtils.getMap(val);
        }
        if (MongoDBUtils.isSudDocumentList(val)) {
            return StreamSupport.stream(((Iterable)Iterable.class.cast(val)).spliterator(), false).map(MongoDBUtils::getMap).collect(Collectors.toList());
        }
        return val;
    }

    public static List<org.eclipse.jnosql.communication.document.Document> of(Map<String, ?> values) {
        Predicate<String> isNotNull = s -> values.get(s) != null;
        Function<String, org.eclipse.jnosql.communication.document.Document> documentMap = key -> {
            Object value = values.get(key);
            return MongoDBUtils.getDocument(key, value);
        };
        return values.keySet().stream().filter(isNotNull).map(documentMap).collect(Collectors.toList());
    }

    private static org.eclipse.jnosql.communication.document.Document getDocument(String key, Object value) {
        if (value instanceof Document) {
            return org.eclipse.jnosql.communication.document.Document.of((String)key, MongoDBUtils.of((Map)Document.class.cast(value)));
        }
        if (MongoDBUtils.isDocumentIterable(value)) {
            ArrayList documents = new ArrayList();
            for (Object object : (Iterable)Iterable.class.cast(value)) {
                Map map = (Map)Map.class.cast(object);
                documents.add(map.entrySet().stream().map(e -> MongoDBUtils.getDocument(e.getKey().toString(), e.getValue())).collect(Collectors.toList()));
            }
            return org.eclipse.jnosql.communication.document.Document.of((String)key, documents);
        }
        return org.eclipse.jnosql.communication.document.Document.of((String)key, (Object)Value.of((Object)MongoDBUtils.convertValue(value)));
    }

    private static Object convertValue(Object value) {
        if (value instanceof Binary) {
            return ((Binary)Binary.class.cast(value)).getData();
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDocumentIterable(Object value) {
        if (!(value instanceof Iterable)) return false;
        if (!StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(Document.class::isInstance)) return false;
        return true;
    }

    private static Object getMap(Object val) {
        return StreamSupport.stream(((Iterable)Iterable.class.cast(val)).spliterator(), false).collect(Collectors.toMap(KEY_DOCUMENT, VALUE_DOCUMENT));
    }

    private static org.eclipse.jnosql.communication.document.Document cast(Object document) {
        return (org.eclipse.jnosql.communication.document.Document)org.eclipse.jnosql.communication.document.Document.class.cast(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSudDocument(Object value) {
        if (!(value instanceof Iterable)) return false;
        if (!StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(org.eclipse.jnosql.communication.document.Document.class::isInstance)) return false;
        return true;
    }

    private static boolean isSudDocumentList(Object value) {
        return value instanceof Iterable && StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(d -> d instanceof Iterable && MongoDBUtils.isSudDocument(d));
    }
}

