/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import com.mongodb.client.model.Filters;
import java.util.List;
import org.bson.conversions.Bson;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.ValueUtil;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.Element;

final class DocumentQueryConversor {
    private DocumentQueryConversor() {
    }

    public static Bson convert(CriteriaCondition condition) {
        Element document = condition.element();
        Object value = ValueUtil.convert((Value)document.value());
        return switch (condition.condition()) {
            case Condition.EQUALS -> Filters.eq((String)document.name(), (Object)value);
            case Condition.GREATER_THAN -> Filters.gt((String)document.name(), (Object)value);
            case Condition.GREATER_EQUALS_THAN -> Filters.gte((String)document.name(), (Object)value);
            case Condition.LESSER_THAN -> Filters.lt((String)document.name(), (Object)value);
            case Condition.LESSER_EQUALS_THAN -> Filters.lte((String)document.name(), (Object)value);
            case Condition.IN -> {
                List inList = ValueUtil.convertToList((Value)document.value());
                yield Filters.in((String)document.name(), (Object[])inList.toArray());
            }
            case Condition.NOT -> Filters.not((Bson)DocumentQueryConversor.convert((CriteriaCondition)document.get(CriteriaCondition.class)));
            case Condition.LIKE -> Filters.regex((String)document.name(), (String)value.toString());
            case Condition.AND -> {
                List andList = (List)condition.element().value().get((TypeSupplier)new TypeReference<List<CriteriaCondition>>(){});
                yield Filters.and(andList.stream().map(DocumentQueryConversor::convert).toList());
            }
            case Condition.OR -> {
                List orList = (List)condition.element().value().get((TypeSupplier)new TypeReference<List<CriteriaCondition>>(){});
                yield Filters.or(orList.stream().map(DocumentQueryConversor::convert).toList());
            }
            default -> throw new UnsupportedOperationException("The condition " + condition.condition() + " is not supported from mongoDB diana driver");
        };
    }
}

