/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.conversions.Bson;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.ValueUtil;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.Element;

final class DocumentQueryConversor {
    private DocumentQueryConversor() {
    }

    public static Bson convert(CriteriaCondition condition) {
        Element document = condition.element();
        Object value = ValueUtil.convert((Value)document.value());
        return switch (condition.condition()) {
            case Condition.EQUALS -> Filters.eq((String)document.name(), (Object)value);
            case Condition.GREATER_THAN -> Filters.gt((String)document.name(), (Object)value);
            case Condition.GREATER_EQUALS_THAN -> Filters.gte((String)document.name(), (Object)value);
            case Condition.LESSER_THAN -> Filters.lt((String)document.name(), (Object)value);
            case Condition.LESSER_EQUALS_THAN -> Filters.lte((String)document.name(), (Object)value);
            case Condition.IN -> {
                List inList = ValueUtil.convertToList((Value)document.value());
                yield Filters.in((String)document.name(), (Object[])inList.toArray());
            }
            case Condition.NOT -> {
                Element element;
                CriteriaCondition criteriaCondition = (CriteriaCondition)document.get(CriteriaCondition.class);
                if (Condition.EQUALS.equals((Object)criteriaCondition.condition()) && (element = criteriaCondition.element()).get() == null) {
                    yield Filters.exists((String)element.name(), (boolean)true);
                }
                yield Filters.nor((Bson[])new Bson[]{DocumentQueryConversor.convert(criteriaCondition)});
            }
            case Condition.LIKE -> Filters.regex((String)document.name(), (Pattern)Pattern.compile(DocumentQueryConversor.prepareRegexValue(value.toString())));
            case Condition.AND -> {
                List andList = (List)condition.element().value().get((TypeSupplier)new TypeReference<List<CriteriaCondition>>(){});
                yield Filters.and(andList.stream().map(DocumentQueryConversor::convert).toList());
            }
            case Condition.OR -> {
                List orList = (List)condition.element().value().get((TypeSupplier)new TypeReference<List<CriteriaCondition>>(){});
                yield Filters.or(orList.stream().map(DocumentQueryConversor::convert).toList());
            }
            case Condition.BETWEEN -> {
                List betweenList = ValueUtil.convertToList((Value)document.value());
                yield Filters.and((Bson[])new Bson[]{Filters.gte((String)document.name(), betweenList.get(0)), Filters.lte((String)document.name(), betweenList.get(1))});
            }
            default -> throw new UnsupportedOperationException("The condition " + condition.condition() + " is not supported from mongoDB diana driver");
        };
    }

    public static String prepareRegexValue(String rawData) {
        if (rawData == null) {
            return "^$";
        }
        return "^" + rawData.replaceAll("_", ".{1}").replaceAll("%", ".{1,}");
    }
}

