/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jnosql.communication.CommunicationException;
import org.eclipse.jnosql.communication.Configurations;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentConfigurations;

final class MongoAuthentication {
    private MongoAuthentication() {
    }

    static Optional<MongoCredential> of(Settings settings) {
        Optional<String> user = settings.getSupplier(Arrays.asList(MongoDBDocumentConfigurations.USER, Configurations.USER)).map(Object::toString);
        Optional<char[]> password = settings.getSupplier(Arrays.asList(MongoDBDocumentConfigurations.PASSWORD, Configurations.PASSWORD)).map(Object::toString).map(String::toCharArray);
        Optional<String> source = settings.get((Supplier)MongoDBDocumentConfigurations.AUTHENTICATION_SOURCE).map(Object::toString);
        Optional<AuthenticationMechanism> mechanism = settings.get((Supplier)MongoDBDocumentConfigurations.AUTHENTICATION_MECHANISM).map(Object::toString).map(AuthenticationMechanism::fromMechanismName);
        if (!user.isPresent()) {
            return Optional.empty();
        }
        if (!mechanism.isPresent()) {
            return Optional.of(MongoCredential.createCredential((String)user.orElseThrow(MongoAuthentication.missingExceptionUser()), (String)source.orElseThrow(MongoAuthentication.missingExceptionSource()), (char[])password.orElseThrow(MongoAuthentication.missingExceptionPassword())));
        }
        return switch (mechanism.get()) {
            case AuthenticationMechanism.PLAIN -> Optional.of(MongoCredential.createPlainCredential((String)user.orElseThrow(MongoAuthentication.missingExceptionUser()), (String)source.orElseThrow(MongoAuthentication.missingExceptionSource()), (char[])password.orElseThrow(MongoAuthentication.missingExceptionPassword())));
            case AuthenticationMechanism.GSSAPI -> Optional.of(MongoCredential.createGSSAPICredential((String)user.orElseThrow(MongoAuthentication.missingExceptionUser())));
            case AuthenticationMechanism.SCRAM_SHA_1 -> Optional.of(MongoCredential.createScramSha1Credential((String)user.orElseThrow(MongoAuthentication.missingExceptionUser()), (String)source.orElseThrow(MongoAuthentication.missingExceptionSource()), (char[])password.orElseThrow(MongoAuthentication.missingExceptionPassword())));
            case AuthenticationMechanism.MONGODB_X509 -> Optional.of(MongoCredential.createMongoX509Credential((String)user.orElseThrow(MongoAuthentication.missingExceptionUser())));
            case AuthenticationMechanism.SCRAM_SHA_256 -> Optional.of(MongoCredential.createScramSha256Credential((String)user.orElseThrow(MongoAuthentication.missingExceptionUser()), (String)source.orElseThrow(MongoAuthentication.missingExceptionSource()), (char[])password.orElseThrow(MongoAuthentication.missingExceptionPassword())));
            default -> throw new CommunicationException("There is not support to the type: " + mechanism);
        };
    }

    private static Supplier<CommunicationException> missingExceptionUser() {
        return MongoAuthentication.missingException("user");
    }

    private static Supplier<CommunicationException> missingExceptionPassword() {
        return MongoAuthentication.missingException("password");
    }

    private static Supplier<CommunicationException> missingExceptionSource() {
        return MongoAuthentication.missingException("source");
    }

    private static Supplier<CommunicationException> missingException(String parameter) {
        return () -> new CommunicationException("There is a missing parameter in mongoDb authentication: " + parameter);
    }
}

