/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jnosql.communication.Configurations;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.communication.SettingsBuilder;
import org.eclipse.jnosql.communication.driver.ConfigurationReader;
import org.eclipse.jnosql.communication.semistructured.DatabaseConfiguration;
import org.eclipse.jnosql.databases.mongodb.communication.HostPortConfiguration;
import org.eclipse.jnosql.databases.mongodb.communication.MongoAuthentication;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentConfigurations;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentManagerFactory;

public class MongoDBDocumentConfiguration
implements DatabaseConfiguration {
    static final int DEFAULT_PORT = 27017;

    public MongoDBDocumentManagerFactory get(Map<String, String> configurations) throws NullPointerException {
        Objects.requireNonNull(configurations, "configurations is required");
        SettingsBuilder builder = Settings.builder();
        configurations.forEach((arg_0, arg_1) -> ((SettingsBuilder)builder).put(arg_0, arg_1));
        return this.apply(builder.build());
    }

    public MongoDBDocumentManagerFactory get(MongoClient mongoClient) throws NullPointerException {
        Objects.requireNonNull(mongoClient, "mongo client is required");
        return new MongoDBDocumentManagerFactory(mongoClient);
    }

    public MongoDBDocumentManagerFactory apply(Settings settings) throws NullPointerException {
        Objects.requireNonNull(settings, "settings is required");
        List<ServerAddress> servers = settings.prefixSupplier(Arrays.asList(MongoDBDocumentConfigurations.HOST, Configurations.HOST)).stream().map(Object::toString).map(HostPortConfiguration::new).map(HostPortConfiguration::toServerAddress).toList();
        if (servers.isEmpty()) {
            Optional<ConnectionString> connectionString = settings.get((Supplier)MongoDBDocumentConfigurations.URL, String.class).map(ConnectionString::new);
            return connectionString.map(c -> MongoClientSettings.builder().applyConnectionString(c).build()).map(MongoClients::create).map(MongoDBDocumentManagerFactory::new).orElseGet(() -> new MongoDBDocumentManagerFactory(MongoClients.create()));
        }
        Optional<MongoCredential> credential = MongoAuthentication.of(settings);
        MongoClientSettings mongoClientSettings = credential.map(c -> MongoClientSettings.builder().credential(c).applyToClusterSettings(builder -> builder.hosts(servers))).orElseGet(() -> MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(servers))).build();
        return new MongoDBDocumentManagerFactory(MongoClients.create((MongoClientSettings)mongoClientSettings));
    }

    public MongoDBDocumentManagerFactory get(String pathFileConfig) throws NullPointerException {
        Objects.requireNonNull(pathFileConfig, "settings is required");
        Map configuration = ConfigurationReader.from((String)pathFileConfig);
        return this.get(configuration);
    }
}

