/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import java.util.UUID;
import org.eclipse.jnosql.communication.ValueWriter;
import org.eclipse.jnosql.communication.ValueWriterDecorator;
import org.eclipse.jnosql.databases.mongodb.communication.UUIDValueWriter;

final class MongoDBValueWriteDecorator<T, S>
implements ValueWriter<T, S> {
    static final ValueWriter MONGO_DB_VALUE_WRITER = new MongoDBValueWriteDecorator();
    private static final ValueWriter DEFAULT = ValueWriterDecorator.getInstance();
    private static final UUIDValueWriter UUID_VALUE_WRITER = new UUIDValueWriter();

    MongoDBValueWriteDecorator() {
    }

    public boolean test(Class<?> type) {
        return UUID_VALUE_WRITER.test(type) || DEFAULT.test(type);
    }

    public S write(T type) {
        if (type != null && UUID_VALUE_WRITER.test(type.getClass())) {
            return (S)UUID_VALUE_WRITER.write((UUID)type);
        }
        return (S)DEFAULT.write(type);
    }
}

