/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.types.Binary;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.ValueUtil;
import org.eclipse.jnosql.communication.ValueWriter;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBValueWriteDecorator;

final class MongoDBUtils {
    static final String ID_FIELD = "_id";

    private MongoDBUtils() {
    }

    static Document getDocument(CommunicationEntity entity) {
        Document document = new Document();
        entity.elements().forEach(d -> document.append(d.name(), MongoDBUtils.convert(d.value())));
        return document;
    }

    private static Object convert(Value value) {
        Object val = ValueUtil.convert((Value)value, (ValueWriter)MongoDBValueWriteDecorator.MONGO_DB_VALUE_WRITER);
        if (val instanceof Element) {
            Element subDocument = (Element)val;
            Object converted = MongoDBUtils.convert(subDocument.value());
            return new Document(subDocument.name(), converted);
        }
        if (MongoDBUtils.isSudDocument(val)) {
            return MongoDBUtils.getMap(val);
        }
        if (MongoDBUtils.isSudDocumentList(val)) {
            return StreamSupport.stream(((Iterable)Iterable.class.cast(val)).spliterator(), false).map(MongoDBUtils::getMap).toList();
        }
        return val;
    }

    public static List<Element> of(Map<String, ?> values) {
        Predicate<String> isNotNull = s -> values.get(s) != null;
        Function<String, Element> documentMap = key -> {
            Object value = values.get(key);
            return MongoDBUtils.getDocument(key, value);
        };
        return values.keySet().stream().filter(isNotNull).map(documentMap).toList();
    }

    private static Element getDocument(String key, Object value) {
        if (value instanceof Document) {
            return Element.of((String)key, MongoDBUtils.of((Map)Document.class.cast(value)));
        }
        if (MongoDBUtils.isDocumentIterable(value)) {
            ArrayList<List<Element>> documents = new ArrayList<List<Element>>();
            for (Object object : (Iterable)Iterable.class.cast(value)) {
                Map map = (Map)Map.class.cast(object);
                documents.add(map.entrySet().stream().map(e -> MongoDBUtils.getDocument(e.getKey().toString(), e.getValue())).toList());
            }
            return Element.of((String)key, documents);
        }
        return Element.of((String)key, (Object)Value.of((Object)MongoDBUtils.convertValue(value)));
    }

    private static Object convertValue(Object value) {
        if (value instanceof Binary) {
            return ((Binary)Binary.class.cast(value)).getData();
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDocumentIterable(Object value) {
        if (!(value instanceof Iterable)) return false;
        if (!StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(Document.class::isInstance)) return false;
        return true;
    }

    private static Object getMap(Object val) {
        Iterable iterable = (Iterable)Iterable.class.cast(val);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object item : iterable) {
            Element document = MongoDBUtils.cast(item);
            map.put(document.name(), MongoDBUtils.convert(document.value()));
        }
        return map;
    }

    private static Element cast(Object document) {
        return (Element)Element.class.cast(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSudDocument(Object value) {
        if (!(value instanceof Iterable)) return false;
        if (!StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(Element.class::isInstance)) return false;
        return true;
    }

    private static boolean isSudDocumentList(Object value) {
        return value instanceof Iterable && StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(d -> d instanceof Iterable && MongoDBUtils.isSudDocument(d));
    }
}

