/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.communication;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.CommunicationException;
import org.eclipse.jnosql.communication.graph.CommunicationEdge;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.databases.neo4j.communication.EdgeCommunicationException;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JCommunicationException;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JDatabaseManager;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JQueryBuilder;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4jCommunicationEdge;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.TypeSystem;

class DefaultNeo4JDatabaseManager
implements Neo4JDatabaseManager {
    private static final Logger LOGGER = Logger.getLogger(DefaultNeo4JDatabaseManager.class.getName());
    public static final String ID = "_id";
    private final Session session;
    private final String database;

    public DefaultNeo4JDatabaseManager(Session session, String database) {
        this.session = session;
        this.database = database;
    }

    public String name() {
        return this.database;
    }

    public CommunicationEntity insert(CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.insertEntities(Collections.singletonList(entity)).iterator().next();
    }

    public Iterable<CommunicationEntity> insert(Iterable<CommunicationEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return this.insertEntities(entities);
    }

    public Iterable<CommunicationEntity> insert(Iterable<CommunicationEntity> entities, Duration ttl) {
        throw new UnsupportedOperationException("This operation is not supported in Neo4J");
    }

    public CommunicationEntity insert(CommunicationEntity entity, Duration ttl) {
        throw new UnsupportedOperationException("This operation is not supported in Neo4J");
    }

    public CommunicationEntity update(CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        if (!entity.contains(ID)) {
            throw new Neo4JCommunicationException("Cannot update entity without an _id field, entity: " + entity);
        }
        Map entityMap = entity.toMap();
        StringBuilder cypher = new StringBuilder("MATCH (e) WHERE elementId(e) = $elementId SET ");
        entityMap.entrySet().stream().filter(entry -> !ID.equals(entry.getKey())).forEach(entry -> cypher.append("e.").append((String)entry.getKey()).append(" = $").append((String)entry.getKey()).append(", "));
        if (cypher.toString().endsWith(", ")) {
            cypher.setLength(cypher.length() - 2);
        }
        LOGGER.finest(() -> "Executing Cypher query to update entity: " + cypher);
        try (Transaction tx = this.session.beginTransaction();){
            String elementId = (String)((Element)entity.find(ID).orElseThrow(() -> new CommunicationException("Entity must have an ID"))).get(String.class);
            HashMap<String, Object> params = new HashMap<String, Object>(entityMap);
            params.put("elementId", elementId);
            tx.run(cypher.toString(), Values.parameters((Object[])this.flattenMap(params)));
            tx.commit();
        }
        LOGGER.fine("Updated entity: " + entity.name() + " with elementId: " + (String)((Element)entity.find(ID).orElseThrow()).get(String.class));
        return entity;
    }

    public Iterable<CommunicationEntity> update(Iterable<CommunicationEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        entities.forEach(this::update);
        return entities;
    }

    public void delete(DeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String cypher = Neo4JQueryBuilder.INSTANCE.buildQuery(query, parameters);
        LOGGER.fine("Executing Delete Cypher Query: " + cypher);
        try (Transaction tx = this.session.beginTransaction();){
            tx.run(cypher, Values.parameters((Object[])this.flattenMap(parameters)));
            tx.commit();
        }
    }

    public Stream<CommunicationEntity> select(SelectQuery query) {
        Objects.requireNonNull(query, "query is required");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String cypher = Neo4JQueryBuilder.INSTANCE.buildQuery(query, parameters);
        LOGGER.fine("Executing Cypher Query for select entities: " + cypher);
        try (Transaction tx = this.session.beginTransaction();){
            Stream<CommunicationEntity> stream = tx.run(cypher, Values.parameters((Object[])this.flattenMap(parameters))).list(record -> this.extractEntity(query.name(), (Record)record, query.columns().isEmpty())).stream();
            return stream;
        }
    }

    public long count(String entity) {
        long l;
        block8: {
            Objects.requireNonNull(entity, "entity is required");
            Transaction tx = this.session.beginTransaction();
            try {
                String cypher = "MATCH (e:" + entity + ") RETURN count(e) AS count";
                LOGGER.fine("Executing Cypher Query for counting: " + cypher);
                long count = tx.run(cypher).single().get("count").asLong();
                tx.commit();
                l = count;
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.severe("Error executing count query: " + e.getMessage());
                    throw new CommunicationException("Error executing count query", (Throwable)e);
                }
            }
            tx.close();
        }
        return l;
    }

    @Override
    public Stream<CommunicationEntity> cypher(String cypher, Map<String, Object> parameters) {
        Stream<CommunicationEntity> stream;
        block8: {
            Objects.requireNonNull(cypher, "Cypher query is required");
            Objects.requireNonNull(parameters, "Parameters map is required");
            Transaction tx = this.session.beginTransaction();
            try {
                Result result = tx.run(cypher, Values.parameters((Object[])this.flattenMap(parameters)));
                List<CommunicationEntity> entities = result.stream().map(record -> record.keys().stream().map(key -> {
                    Value value = record.get(key);
                    if (value.hasType(TypeSystem.getDefault().NODE())) {
                        return this.extractEntity((String)key, (Record)record, false);
                    }
                    if (value.hasType(TypeSystem.getDefault().RELATIONSHIP())) {
                        Relationship rel = value.asRelationship();
                        ArrayList<Element> elements = new ArrayList<Element>();
                        rel.asMap().forEach((k, v) -> elements.add(Element.of((String)k, (Object)v)));
                        elements.add(Element.of((String)ID, (Object)rel.elementId()));
                        elements.add(Element.of((String)"start", (Object)rel.startNodeElementId()));
                        elements.add(Element.of((String)"end", (Object)rel.endNodeElementId()));
                        return CommunicationEntity.of((String)key, elements);
                    }
                    return null;
                }).filter(Objects::nonNull).findFirst().orElse(null)).filter(Objects::nonNull).toList();
                LOGGER.fine("Executed Cypher query: " + cypher);
                tx.commit();
                stream = entities.stream();
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CommunicationException("Error executing Cypher query", (Throwable)e);
                }
            }
            tx.close();
        }
        return stream;
    }

    @Override
    public Stream<CommunicationEntity> cypher(String cypher) {
        return this.cypher(cypher, Collections.emptyMap());
    }

    @Override
    public Stream<CommunicationEntity> traverse(String startNodeId, String label, int depth) {
        Objects.requireNonNull(startNodeId, "Start node ID is required");
        Objects.requireNonNull(label, "Relationship type is required");
        String cypher = "MATCH (startNode) WHERE elementId(startNode) = $elementId MATCH (startNode)-[r:" + label + "*1.." + depth + "]-(endNode) RETURN endNode";
        try (Transaction tx = this.session.beginTransaction();){
            Stream<CommunicationEntity> result = tx.run(cypher, Values.parameters((Object[])new Object[]{"elementId", startNodeId})).list(record -> this.extractEntity("TraversalResult", (Record)record, false)).stream();
            LOGGER.fine("Executed traversal query: " + cypher);
            tx.commit();
            Stream<CommunicationEntity> stream = result;
            return stream;
        }
    }

    @Override
    public void edge(CommunicationEntity source, String label, CommunicationEntity target) {
        Objects.requireNonNull(source, "Source entity is required");
        Objects.requireNonNull(target, "Target entity is required");
        Objects.requireNonNull(label, "Relationship type is required");
        String cypher = "MATCH (s) WHERE elementId(s) = $sourceElementId MATCH (t) WHERE elementId(t) = $targetElementId WITH s, t WHERE NOT EXISTS { MATCH (s)-[r:" + label + "]->(t) } CREATE (s)-[r:" + label + "]->(t)";
        try (Transaction tx = this.session.beginTransaction();){
            Object sourceId = ((Element)source.find(ID).orElseThrow(() -> new EdgeCommunicationException("The source entity should have the _id property"))).get();
            Object targetId = ((Element)target.find(ID).orElseThrow(() -> new EdgeCommunicationException("The target entity should have the _id property"))).get();
            tx.run(cypher, Values.parameters((Object[])new Object[]{"sourceElementId", sourceId, "targetElementId", targetId}));
            LOGGER.fine("Created edge: " + cypher);
            tx.commit();
        }
    }

    @Override
    public void remove(CommunicationEntity source, String label, CommunicationEntity target) {
        Objects.requireNonNull(source, "Source entity is required");
        Objects.requireNonNull(target, "Target entity is required");
        Objects.requireNonNull(label, "Relationship type is required");
        String cypher = "MATCH (s) WHERE elementId(s) = $sourceElementId MATCH (t) WHERE elementId(t) = $targetElementId MATCH (s)-[r:" + label + "]-(t) DELETE r";
        Object sourceId = ((Element)source.find(ID).orElseThrow(() -> new EdgeCommunicationException("The source entity should have the _id property"))).get();
        Object targetId = ((Element)target.find(ID).orElseThrow(() -> new EdgeCommunicationException("The target entity should have the _id property"))).get();
        try (Transaction tx = this.session.beginTransaction();){
            tx.run(cypher, Values.parameters((Object[])new Object[]{"sourceElementId", sourceId, "targetElementId", targetId}));
            LOGGER.fine("Removed edge: " + cypher);
            tx.commit();
        }
    }

    public <K> void deleteEdge(K id) {
        Objects.requireNonNull(id, "The id is required");
        LOGGER.fine(() -> "Deleting edge with ID: " + id);
        String cypher = "MATCH ()-[r]-() WHERE elementId(r) = $elementId DELETE r";
        try (Transaction tx = this.session.beginTransaction();){
            tx.run(cypher, Values.parameters((Object[])new Object[]{"elementId", id}));
            LOGGER.fine(() -> "Deleted edge with ID: " + id);
            tx.commit();
        }
    }

    public <K> Optional<CommunicationEdge> findEdgeById(K id) {
        Objects.requireNonNull(id, "The edge ID is required");
        String cypher = "MATCH (s)-[r]->(t) WHERE elementId(r) = $edgeId RETURN r, s, t";
        LOGGER.fine(() -> "Find edge with ID: " + id);
        try (Transaction tx = this.session.beginTransaction();){
            Result result = tx.run(cypher, Values.parameters((Object[])new Object[]{"edgeId", id}));
            if (result.hasNext()) {
                LOGGER.fine(() -> "Found edge with ID: " + id);
                Record record = result.next();
                Relationship relationship = record.get("r").asRelationship();
                Node sourceNode = record.get("s").asNode();
                Node targetNode = record.get("t").asNode();
                CommunicationEntity sourceEntity = this.extractEntity((String)sourceNode.labels().iterator().next(), record, true);
                CommunicationEntity targetEntity = this.extractEntity((String)targetNode.labels().iterator().next(), record, true);
                Map properties = relationship.asMap();
                Optional<CommunicationEdge> optional = Optional.of(new Neo4jCommunicationEdge(relationship.elementId(), sourceEntity, targetEntity, relationship.type(), properties));
                return optional;
            }
        }
        return Optional.empty();
    }

    public CommunicationEdge edge(CommunicationEntity source, String label, CommunicationEntity target, Map<String, Object> properties) {
        Objects.requireNonNull(source, "Source entity is required");
        Objects.requireNonNull(target, "Target entity is required");
        Objects.requireNonNull(label, "Relationship type is required");
        Objects.requireNonNull(properties, "Properties map is required");
        source = this.ensureEntityExists(source);
        target = this.ensureEntityExists(target);
        Object sourceId = ((Element)source.find(ID).orElseThrow(() -> new EdgeCommunicationException("The source entity should have the _id property"))).get();
        Object targetId = ((Element)target.find(ID).orElseThrow(() -> new EdgeCommunicationException("The target entity should have the _id property"))).get();
        try (Transaction tx = this.session.beginTransaction();){
            Relationship relationship;
            String findEdge = "MATCH (s) WHERE elementId(s) = $sourceElementId MATCH (t) WHERE elementId(t) = $targetElementId MATCH (s)-[r:" + label + "]->(t) RETURN r";
            LOGGER.fine(() -> "Finding existing edge with ID: " + sourceId + " to " + targetId);
            LOGGER.fine(() -> "Cypher Query: " + findEdge);
            Result result = tx.run(findEdge, Values.parameters((Object[])new Object[]{"sourceElementId", sourceId, "targetElementId", targetId}));
            if (result.hasNext()) {
                String updateQuery = "MATCH (s)-[r:" + label + "]->(t) WHERE elementId(s) = $sourceElementId AND elementId(t) = $targetElementId SET r += $props RETURN r";
                LOGGER.fine(() -> "Updating existing edge with ID: " + sourceId + " to " + targetId);
                LOGGER.fine(() -> "Cypher Query: " + updateQuery);
                Result updateResult = tx.run(updateQuery, Values.parameters((Object[])new Object[]{"sourceElementId", sourceId, "targetElementId", targetId, "props", properties}));
                relationship = updateResult.single().get("r").asRelationship();
                LOGGER.fine(() -> "Found existing edge with ID: " + relationship.elementId());
            } else {
                String createEdge = "MATCH (s) WHERE elementId(s) = $sourceElementId MATCH (t) WHERE elementId(t) = $targetElementId CREATE (s)-[r:" + label + " $props]->(t) RETURN r";
                LOGGER.fine(() -> "Creating new edge with ID: " + sourceId + " to " + targetId);
                LOGGER.fine(() -> "Cypher Query: " + createEdge);
                Result createResult = tx.run(createEdge, Values.parameters((Object[])new Object[]{"sourceElementId", sourceId, "targetElementId", targetId, "props", properties}));
                relationship = createResult.single().get("r").asRelationship();
                LOGGER.fine(() -> "Created new edge with ID: " + relationship.elementId());
            }
            tx.commit();
            Neo4jCommunicationEdge neo4jCommunicationEdge = new Neo4jCommunicationEdge(relationship.elementId(), source, target, label, properties);
            return neo4jCommunicationEdge;
        }
    }

    private CommunicationEntity ensureEntityExists(CommunicationEntity entity) {
        return entity.find(ID).filter(this::entityExists).map(id -> entity).orElseGet(() -> this.insert(entity));
    }

    private boolean entityExists(Element id) {
        String cypher = "MATCH (e) WHERE elementId(e) = $id RETURN count(e) > 0 AS exists";
        try (Transaction tx = this.session.beginTransaction();){
            Result result = tx.run(cypher, Values.parameters((Object[])new Object[]{"id", id.get()}));
            boolean exists = result.single().get("exists").asBoolean();
            LOGGER.fine(() -> "Checking if entity exists with ID: " + id + " result: " + exists);
            boolean bl = exists;
            return bl;
        }
    }

    public void close() {
        LOGGER.fine("Closing the Neo4J session, the database name is: " + this.database);
        this.session.close();
    }

    private Object[] flattenMap(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(entry -> Stream.of(entry.getKey(), entry.getValue())).toArray();
    }

    private Iterable<CommunicationEntity> insertEntities(Iterable<CommunicationEntity> entities) {
        ArrayList<CommunicationEntity> entitiesResult = new ArrayList<CommunicationEntity>();
        try (Transaction tx = this.session.beginTransaction();){
            for (CommunicationEntity entity : entities) {
                Map properties = entity.toMap();
                StringBuilder cypher = new StringBuilder("CREATE (e:");
                cypher.append(entity.name()).append(" {");
                properties.keySet().forEach(key -> cypher.append((String)key).append(": $").append((String)key).append(", "));
                if (!properties.isEmpty()) {
                    cypher.setLength(cypher.length() - 2);
                }
                cypher.append("}) RETURN e");
                LOGGER.fine("Executing Cypher Query to insert entities: " + cypher);
                Result result = tx.run(cypher.toString(), Values.parameters((Object[])this.flattenMap(properties)));
                Record record = result.hasNext() ? result.next() : null;
                Node insertedNode = record.get("e").asNode();
                entity.add(ID, (Object)insertedNode.elementId());
                entitiesResult.add(entity);
            }
            tx.commit();
        }
        LOGGER.fine("Inserted entities: " + entitiesResult.size());
        return entitiesResult;
    }

    private CommunicationEntity extractEntity(String alias, Record record, boolean isFullNode) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (String key : record.keys()) {
            Value value = record.get(key);
            if (value.hasType(TypeSystem.getDefault().NODE())) {
                Node node = value.asNode();
                node.asMap().forEach((k, v) -> elements.add(Element.of((String)k, (Object)v)));
                elements.add(Element.of((String)ID, (Object)node.elementId()));
                elements.add(Element.of((String)"_alias", (Object)key));
                String label = node.labels().iterator().hasNext() ? (String)node.labels().iterator().next() : key;
                return CommunicationEntity.of((String)label, elements);
            }
            if (value.hasType(TypeSystem.getDefault().RELATIONSHIP())) {
                Relationship rel = value.asRelationship();
                rel.asMap().forEach((k, v) -> elements.add(Element.of((String)k, (Object)v)));
                elements.add(Element.of((String)ID, (Object)rel.elementId()));
                elements.add(Element.of((String)"start", (Object)rel.startNodeElementId()));
                elements.add(Element.of((String)"end", (Object)rel.endNodeElementId()));
                elements.add(Element.of((String)"_alias", (Object)key));
                return CommunicationEntity.of((String)rel.type(), elements);
            }
            String fieldName = key.contains(".") ? key.substring(key.indexOf(46) + 1) : key;
            elements.add(Element.of((String)fieldName, (Object)value.asObject()));
        }
        return CommunicationEntity.of((String)alias, elements);
    }
}

