/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.communication;

import java.util.function.Supplier;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.communication.semistructured.DatabaseConfiguration;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JConfigurations;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JDatabaseManagerFactory;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4Property;

public final class Neo4JConfiguration
implements DatabaseConfiguration {
    private static final Logger LOGGER = Logger.getLogger(Neo4JConfiguration.class.getName());
    private static final String DEFAULT_BOLT = "bolt://localhost:7687";

    public Neo4JDatabaseManagerFactory apply(Settings settings) {
        String uri = (String)settings.getOrDefault((Supplier)Neo4JConfigurations.URI, (Object)DEFAULT_BOLT);
        String user = settings.get((Supplier)Neo4JConfigurations.USERNAME, String.class).orElse(null);
        String password = settings.get((Supplier)Neo4JConfigurations.PASSWORD, String.class).orElse(null);
        LOGGER.info("Starting configuration to Neo4J database, the uri: " + uri);
        Neo4Property neo4Property = new Neo4Property(uri, user, password);
        return Neo4JDatabaseManagerFactory.of(neo4Property);
    }
}

