/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.communication;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jnosql.communication.CommunicationException;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.databases.neo4j.communication.LikeToCypherRegex;

enum Neo4JQueryBuilder {
    INSTANCE;

    private static final String INTERNAL_ID = "_id";

    String buildQuery(DeleteQuery query, Map<String, Object> parameters) {
        StringBuilder cypher = new StringBuilder("MATCH (e:");
        cypher.append(query.name()).append(")");
        query.condition().ifPresent(c -> {
            cypher.append(" WHERE ");
            this.createWhereClause(cypher, (CriteriaCondition)c, parameters);
        });
        List columns = query.columns();
        if (!columns.isEmpty()) {
            cypher.append(" SET ");
            cypher.append(columns.stream().map(this::translateField).map(col -> col + " = NULL").collect(Collectors.joining(", ")));
        } else {
            cypher.append(" DELETE e");
        }
        return cypher.toString();
    }

    String buildQuery(SelectQuery query, Map<String, Object> parameters) {
        StringBuilder cypher = new StringBuilder("MATCH (e:");
        cypher.append(query.name()).append(")");
        query.condition().ifPresent(c -> {
            cypher.append(" WHERE ");
            this.createWhereClause(cypher, (CriteriaCondition)c, parameters);
        });
        if (!query.sorts().isEmpty()) {
            cypher.append(" ORDER BY ");
            cypher.append(query.sorts().stream().map(sort -> "e." + sort.property() + (sort.isAscending() ? " ASC" : " DESC")).collect(Collectors.joining(", ")));
        }
        if (query.skip() > 0L) {
            cypher.append(" SKIP ").append(query.skip());
        }
        if (query.limit() > 0L) {
            cypher.append(" LIMIT ").append(query.limit());
        }
        cypher.append(" RETURN ");
        List columns = query.columns();
        if (columns.isEmpty()) {
            cypher.append("e");
        } else {
            cypher.append(columns.stream().map(this::translateField).collect(Collectors.joining(", ")));
        }
        return cypher.toString();
    }

    private void createWhereClause(StringBuilder cypher, CriteriaCondition condition, Map<String, Object> parameters) {
        Element element = condition.element();
        String fieldName = element.name();
        String queryField = this.translateField(fieldName);
        switch (condition.condition()) {
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUALS_THAN: 
            case LESSER_THAN: 
            case LESSER_EQUALS_THAN: 
            case LIKE: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case CONTAINS: 
            case IN: {
                String paramName = INTERNAL_ID.equals(fieldName) ? "id" : fieldName;
                parameters.put(paramName, this.value(element.get(), condition.condition()));
                cypher.append(queryField).append(" ").append(this.getConditionOperator(condition.condition())).append(" $").append(paramName);
                break;
            }
            case NOT: {
                cypher.append("NOT (");
                this.createWhereClause(cypher, (CriteriaCondition)element.get(CriteriaCondition.class), parameters);
                cypher.append(")");
                break;
            }
            case AND: 
            case OR: {
                cypher.append("(");
                List conditions = (List)element.get((TypeSupplier)new TypeReference<List<CriteriaCondition>>(){});
                for (int index = 0; index < conditions.size(); ++index) {
                    if (index > 0) {
                        cypher.append(" ").append(this.getConditionOperator(condition.condition())).append(" ");
                    }
                    this.createWhereClause(cypher, (CriteriaCondition)conditions.get(index), parameters);
                }
                cypher.append(")");
                break;
            }
            default: {
                throw new CommunicationException("Unsupported condition: " + condition.condition());
            }
        }
    }

    private Object value(Object value, Condition condition) {
        if (Condition.LIKE.equals((Object)condition)) {
            return LikeToCypherRegex.INSTANCE.toCypherRegex(value.toString());
        }
        return value;
    }

    private String translateField(String field) {
        if (INTERNAL_ID.equals(field)) {
            return "elementId(e)";
        }
        if (field.startsWith("e.")) {
            return field;
        }
        return "e." + field;
    }

    private String getConditionOperator(Condition condition) {
        return switch (condition) {
            case Condition.EQUALS -> "=";
            case Condition.GREATER_THAN -> ">";
            case Condition.GREATER_EQUALS_THAN -> ">=";
            case Condition.LESSER_THAN -> "<";
            case Condition.LESSER_EQUALS_THAN -> "<=";
            case Condition.LIKE -> "=~";
            case Condition.IN -> "IN";
            case Condition.AND -> "AND";
            case Condition.OR -> "OR";
            case Condition.STARTS_WITH -> "STARTS WITH";
            case Condition.ENDS_WITH -> "ENDS WITH";
            case Condition.CONTAINS -> "CONTAINS";
            default -> throw new CommunicationException("Unsupported operator: " + condition);
        };
    }
}

