/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.mapping;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.graph.GraphDatabaseManager;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JDatabaseManager;
import org.eclipse.jnosql.databases.neo4j.mapping.Neo4JTemplate;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.graph.AbstractGraphTemplate;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;
import org.eclipse.jnosql.mapping.semistructured.EventPersistManager;

@ApplicationScoped
@Typed(value={Neo4JTemplate.class})
class DefaultNeo4JTemplate
extends AbstractGraphTemplate
implements Neo4JTemplate {
    private Instance<Neo4JDatabaseManager> manager;
    private EntityConverter converter;
    private EntitiesMetadata entities;
    private Converters converters;
    private EventPersistManager persistManager;

    @Inject
    DefaultNeo4JTemplate(Instance<Neo4JDatabaseManager> manager, EntityConverter converter, EntitiesMetadata entities, Converters converters, EventPersistManager persistManager) {
        this.manager = manager;
        this.converter = converter;
        this.entities = entities;
        this.converters = converters;
        this.persistManager = persistManager;
    }

    @Override
    public <T> Stream<T> cypher(String cypher, Map<String, Object> parameters) {
        Objects.requireNonNull(cypher, "cypher is required");
        Objects.requireNonNull(parameters, "parameters is required");
        return ((Neo4JDatabaseManager)this.manager.get()).cypher(cypher, parameters).map(e -> this.converter.toEntity(e));
    }

    @Override
    public <T> Stream<T> cypher(String cypher) {
        Objects.requireNonNull(cypher, "cypher is required");
        return ((Neo4JDatabaseManager)this.manager.get()).cypher(cypher).map(e -> this.converter.toEntity(e));
    }

    @Override
    public <T> Stream<T> traverse(String startNodeId, Supplier<String> relationship, int depth) {
        Objects.requireNonNull(startNodeId, "startNodeId is required");
        Objects.requireNonNull(relationship, "relationship is required");
        return this.traverse(startNodeId, relationship.get(), depth);
    }

    @Override
    public <T> Stream<T> traverse(String startNodeId, String relationship, int depth) {
        Objects.requireNonNull(startNodeId, "startNodeId is required");
        Objects.requireNonNull(relationship, "relationship is required");
        return ((Neo4JDatabaseManager)this.manager.get()).traverse(startNodeId, relationship, depth).map(e -> this.converter.toEntity(e));
    }

    protected EntityConverter converter() {
        return this.converter;
    }

    protected GraphDatabaseManager manager() {
        return (GraphDatabaseManager)this.manager.get();
    }

    protected EventPersistManager eventManager() {
        return this.persistManager;
    }

    protected EntitiesMetadata entities() {
        return this.entities;
    }

    protected Converters converters() {
        return this.converters;
    }
}

