/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.mapping;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jnosql.databases.neo4j.mapping.Cypher;
import org.eclipse.jnosql.databases.neo4j.mapping.Neo4JTemplate;
import org.eclipse.jnosql.databases.neo4j.mapping.ParamConverterUtils;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.query.AbstractRepository;
import org.eclipse.jnosql.mapping.core.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.query.AbstractSemiStructuredRepositoryProxy;
import org.eclipse.jnosql.mapping.semistructured.query.SemiStructuredRepositoryProxy;

class Neo4JRepositoryProxy<T, K>
extends AbstractSemiStructuredRepositoryProxy<T, K> {
    private final Class<T> typeClass;
    private final Neo4JTemplate template;
    private final AbstractRepository<T, K> repository;
    private final Converters converters;
    private final EntityMetadata entityMetadata;
    private final Class<?> repositoryType;

    Neo4JRepositoryProxy(Neo4JTemplate template, Class<?> repositoryType, Converters converters, EntitiesMetadata entitiesMetadata) {
        this.template = template;
        this.typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.converters = converters;
        this.entityMetadata = entitiesMetadata.get(this.typeClass);
        this.repositoryType = repositoryType;
        this.repository = SemiStructuredRepositoryProxy.SemiStructuredRepository.of((SemiStructuredTemplate)template, (EntityMetadata)this.entityMetadata);
    }

    protected AbstractRepository<T, K> repository() {
        return this.repository;
    }

    protected Converters converters() {
        return this.converters;
    }

    protected Class<?> repositoryType() {
        return this.repositoryType;
    }

    protected EntityMetadata entityMetadata() {
        return this.entityMetadata;
    }

    protected Neo4JTemplate template() {
        return this.template;
    }

    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        Cypher cql = method.getAnnotation(Cypher.class);
        if (Objects.nonNull(cql)) {
            Map<String, Object> values = ParamConverterUtils.getValues(args, method);
            Stream result = !values.isEmpty() ? this.template.cypher(cql.value(), values) : this.template.cypher(cql.value(), Collections.emptyMap());
            return DynamicReturn.builder().classSource(this.typeClass).methodSource(method).result(() -> result).singleResult((Supplier)DynamicReturn.toSingleResult((Method)method).apply(() -> result)).build().execute();
        }
        return super.invoke(instance, method, args);
    }
}

