/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.cassandra.column;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.eclipse.jnosql.mapping.cassandra.column.CassandraRepository;
import org.eclipse.jnosql.mapping.cassandra.column.CassandraRepositoryBean;

public class CassandraExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(CassandraExtension.class.getName());
    private final Collection<Class<?>> crudTypes = new HashSet();

    <T extends CassandraRepository> void onProcessAnnotatedType(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (CassandraRepository.class.equals((Object)javaClass)) {
            return;
        }
        if (Arrays.asList(javaClass.getInterfaces()).contains(CassandraRepository.class) && Modifier.isInterface(javaClass.getModifiers())) {
            this.crudTypes.add(javaClass);
        }
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        LOGGER.info("Starting the onAfterBeanDiscovery with elements number: " + this.crudTypes.size());
        this.crudTypes.forEach(type -> afterBeanDiscovery.addBean((Bean)new CassandraRepositoryBean((Class<?>)type)));
        LOGGER.info("Finished the onAfterBeanDiscovery");
    }
}

