/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.cassandra.column;

import jakarta.nosql.mapping.Repository;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jnosql.mapping.cassandra.column.CQL;
import org.eclipse.jnosql.mapping.cassandra.column.CQLObjectUtil;
import org.eclipse.jnosql.mapping.cassandra.column.CassandraTemplate;
import org.eclipse.jnosql.mapping.repository.DynamicReturn;

class CassandraRepositoryProxy<T>
implements InvocationHandler {
    private final Class<T> typeClass;
    private final CassandraTemplate template;
    private final Repository<T, ?> repository;

    CassandraRepositoryProxy(CassandraTemplate template, Class<?> repositoryType, Repository<T, ?> repository) {
        this.template = template;
        this.typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.repository = repository;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        CQL cql = method.getAnnotation(CQL.class);
        if (Objects.nonNull(cql)) {
            Map<String, Object> values = CQLObjectUtil.getValues(args, method);
            Stream result = !values.isEmpty() ? this.template.cql(cql.value(), values) : (args == null || args.length == 0 ? this.template.cql(cql.value()) : this.template.cql(cql.value(), args));
            return DynamicReturn.builder().withClassSource(this.typeClass).withMethodSource(method).withResult(() -> result).withSingleResult((Supplier)DynamicReturn.toSingleResult((Method)method).apply(() -> result)).build().execute();
        }
        return method.invoke(this.repository, args);
    }
}

