/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.cassandra.column;

import jakarta.nosql.column.Column;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.column.ColumnEntityConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.cassandra.column.UDT;
import org.eclipse.jnosql.mapping.column.ColumnFieldValue;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;

class CassandraUDTType
implements ColumnFieldValue {
    private final String type;
    private final Object value;
    private final FieldMapping field;

    CassandraUDTType(String type, Object value, FieldMapping field) {
        this.value = value;
        this.type = type;
        this.field = Objects.requireNonNull(field, "field is required");
    }

    public Object getValue() {
        return this.value;
    }

    public FieldMapping getField() {
        return this.field;
    }

    public boolean isNotEmpty() {
        return this.value != null;
    }

    public List<Column> toColumn(ColumnEntityConverter converter, Converters converters) {
        if (Iterable.class.isInstance(this.value)) {
            ArrayList columns = new ArrayList();
            StreamSupport.stream(((Iterable)Iterable.class.cast(this.value)).spliterator(), false).forEach(c -> columns.add(converter.toColumn(c).getColumns()));
            return Collections.singletonList(UDT.builder((String)this.type).withName(this.field.getName()).addUDTs(columns).build());
        }
        return Collections.singletonList(UDT.builder((String)this.type).withName(this.field.getName()).addUDT((Iterable)converter.toColumn(this.value).getColumns()).build());
    }

    public String toString() {
        String sb = "CassandraUDTType{type='" + this.type + "', value=" + this.value + ", field=" + this.field + "}";
        return sb;
    }
}

