/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.cassandra.column;

import jakarta.nosql.Settings;
import jakarta.nosql.mapping.MappingException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import org.eclipse.jnosql.communication.cassandra.column.CassandraColumnManager;
import org.eclipse.jnosql.communication.cassandra.column.CassandraColumnManagerFactory;
import org.eclipse.jnosql.communication.cassandra.column.CassandraConfiguration;
import org.eclipse.jnosql.mapping.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.config.MicroProfileSettings;

@ApplicationScoped
class ColumnManagerSupplier
implements Supplier<CassandraColumnManager> {
    private static final Logger LOGGER = Logger.getLogger(ColumnManagerSupplier.class.getName());

    ColumnManagerSupplier() {
    }

    @Override
    @Produces
    @Typed(value={CassandraColumnManager.class})
    public CassandraColumnManager get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        CassandraConfiguration configuration = new CassandraConfiguration();
        CassandraColumnManagerFactory factory = configuration.apply((Settings)settings);
        Optional database = settings.get((Supplier)MappingConfigurations.COLUMN_DATABASE, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + MappingConfigurations.COLUMN_DATABASE));
        CassandraColumnManager manager = factory.apply(db);
        LOGGER.log(Level.FINEST, "Starting  a CassandraColumnManager instance using Eclipse MicroProfile Config, database name: " + db);
        return manager;
    }

    public void close(@Disposes CassandraColumnManager manager) {
        LOGGER.log(Level.FINEST, "Closing CassandraColumnManager resource, database name: " + manager.getName());
        manager.close();
    }
}

