/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.cassandra.column;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.column.ColumnEntityConverter;
import jakarta.nosql.mapping.column.ColumnEventPersistManager;
import jakarta.nosql.mapping.column.ColumnWorkflow;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.eclipse.jnosql.communication.cassandra.column.CassandraColumnManager;
import org.eclipse.jnosql.communication.cassandra.column.CassandraPreparedStatement;
import org.eclipse.jnosql.mapping.cassandra.column.CassandraColumnEntityConverter;
import org.eclipse.jnosql.mapping.cassandra.column.CassandraColumnWorkflow;
import org.eclipse.jnosql.mapping.cassandra.column.CassandraTemplate;
import org.eclipse.jnosql.mapping.column.AbstractColumnTemplate;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;

@Typed(value={CassandraTemplate.class})
@ApplicationScoped
class DefaultCassandraTemplate
extends AbstractColumnTemplate
implements CassandraTemplate {
    private Instance<CassandraColumnManager> manager;
    private CassandraColumnEntityConverter converter;
    private CassandraColumnWorkflow flow;
    private ColumnEventPersistManager persistManager;
    private EntitiesMetadata entities;
    private Converters converters;

    @Inject
    DefaultCassandraTemplate(Instance<CassandraColumnManager> manager, CassandraColumnEntityConverter converter, CassandraColumnWorkflow flow, ColumnEventPersistManager persistManager, EntitiesMetadata entities, Converters converters) {
        this.manager = manager;
        this.converter = converter;
        this.flow = flow;
        this.persistManager = persistManager;
        this.entities = entities;
        this.converters = converters;
    }

    DefaultCassandraTemplate() {
    }

    protected ColumnEntityConverter getConverter() {
        return this.converter;
    }

    protected ColumnManager getManager() {
        return (ColumnManager)this.manager.get();
    }

    protected ColumnWorkflow getFlow() {
        return this.flow;
    }

    protected ColumnEventPersistManager getEventManager() {
        return this.persistManager;
    }

    protected EntitiesMetadata getEntities() {
        return this.entities;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    @Override
    public <T> T save(T entity, ConsistencyLevel level) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(level, "level is required");
        UnaryOperator save = e -> ((CassandraColumnManager)this.manager.get()).save(e, level);
        return (T)this.getFlow().flow(entity, save);
    }

    @Override
    public <T> Iterable<T> save(Iterable<T> entities, Duration ttl, ConsistencyLevel level) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        Objects.requireNonNull(level, "level is required");
        return StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toColumn(arg_0)).map(e -> ((CassandraColumnManager)this.manager.get()).save(e, ttl, level)).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toEntity(arg_0)).map(e -> e).collect(Collectors.toList());
    }

    @Override
    public <T> Iterable<T> save(Iterable<T> entities, ConsistencyLevel level) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(level, "level is required");
        return StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toColumn(arg_0)).map(e -> ((CassandraColumnManager)this.manager.get()).save(e, level)).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toEntity(arg_0)).map(e -> e).collect(Collectors.toList());
    }

    @Override
    public <T> T save(T entity, Duration ttl, ConsistencyLevel level) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        Objects.requireNonNull(level, "level is required");
        UnaryOperator save = e -> ((CassandraColumnManager)this.manager.get()).save(e, ttl, level);
        return (T)this.getFlow().flow(entity, save);
    }

    @Override
    public void delete(ColumnDeleteQuery query, ConsistencyLevel level) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(level, "level is required");
        this.persistManager.firePreDeleteQuery(query);
        ((CassandraColumnManager)this.manager.get()).delete(query, level);
    }

    @Override
    public <T> Stream<T> find(ColumnQuery query, ConsistencyLevel level) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(level, "level is required");
        this.persistManager.firePreQuery(query);
        return ((CassandraColumnManager)this.manager.get()).select(query, level).map(c -> this.converter.toEntity((ColumnEntity)c));
    }

    @Override
    public <T> Stream<T> cql(String query) {
        return ((CassandraColumnManager)this.manager.get()).cql(query).map(c -> this.converter.toEntity((ColumnEntity)c));
    }

    @Override
    public <T> Stream<T> cql(String query, Map<String, Object> values) {
        return ((CassandraColumnManager)this.manager.get()).cql(query, values).map(c -> this.converter.toEntity((ColumnEntity)c));
    }

    @Override
    public <T> Stream<T> cql(String query, Object ... params) {
        Objects.requireNonNull(query, "query is required");
        CassandraPreparedStatement cassandraPrepareStatement = ((CassandraColumnManager)this.manager.get()).nativeQueryPrepare(query);
        Stream entities = cassandraPrepareStatement.bind(params).executeQuery();
        return entities.map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toEntity(arg_0)).map(e -> e);
    }

    @Override
    public <T> Stream<T> execute(SimpleStatement statement) {
        return ((CassandraColumnManager)this.manager.get()).execute(statement).map(c -> this.converter.toEntity((ColumnEntity)c));
    }
}

