/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.cassandra.converters;

import jakarta.nosql.mapping.AttributeConverter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class TimestampConverter
implements AttributeConverter<Object, Date> {
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();

    public Date convertToDatabaseColumn(Object attribute) {
        if (attribute == null) {
            return null;
        }
        if (Number.class.isInstance(attribute)) {
            return new Date(((Number)Number.class.cast(attribute)).longValue());
        }
        if (LocalDate.class.isInstance(attribute)) {
            return Date.from(((LocalDate)LocalDate.class.cast(attribute)).atStartOfDay(ZONE_ID).toInstant());
        }
        if (LocalDateTime.class.isInstance(attribute)) {
            return Date.from(((LocalDateTime)LocalDateTime.class.cast(attribute)).atZone(ZONE_ID).toInstant());
        }
        if (ZonedDateTime.class.isInstance(attribute)) {
            return Date.from(((ZonedDateTime)ZonedDateTime.class.cast(attribute)).toInstant());
        }
        if (Date.class.isInstance(attribute)) {
            return (Date)Date.class.cast(attribute);
        }
        if (Calendar.class.isInstance(attribute)) {
            return ((Calendar)Calendar.class.cast(attribute)).getTime();
        }
        throw new IllegalArgumentException("There is not support to: " + attribute.getClass());
    }

    public Object convertToEntityAttribute(Date dbData) {
        return dbData.getTime();
    }
}

