/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.connections;

import com.arangodb.tinkerpop.gremlin.utils.ArangoDBConfigurationBuilder;
import jakarta.nosql.Settings;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.eclipse.jnosql.mapping.graph.GraphConfiguration;
import org.eclipse.jnosql.mapping.graph.connections.ArangoDBGraphConfigurations;

public class ArangoDBGraphConfiguration
implements GraphConfiguration {
    public Graph apply(Settings settings) {
        Objects.requireNonNull(settings, "settings is required");
        ArangoDBConfigurationBuilder builder = new ArangoDBConfigurationBuilder();
        settings.prefix((Supplier)ArangoDBGraphConfigurations.HOST).stream().map(Object::toString).forEach(arg_0 -> ((ArangoDBConfigurationBuilder)builder).arangoHosts(arg_0));
        settings.prefix((Supplier)ArangoDBGraphConfigurations.VERTEX).stream().map(Object::toString).forEach(arg_0 -> ((ArangoDBConfigurationBuilder)builder).withVertexCollection(arg_0));
        settings.prefix((Supplier)ArangoDBGraphConfigurations.EDGE).stream().map(Object::toString).forEach(arg_0 -> ((ArangoDBConfigurationBuilder)builder).withEdgeCollection(arg_0));
        settings.get((Supplier)ArangoDBGraphConfigurations.USER).map(Object::toString).ifPresent(arg_0 -> ((ArangoDBConfigurationBuilder)builder).arangoUser(arg_0));
        settings.get((Supplier)ArangoDBGraphConfigurations.PASSWORD).map(Object::toString).ifPresent(arg_0 -> ((ArangoDBConfigurationBuilder)builder).arangoPassword(arg_0));
        settings.get((Supplier)ArangoDBGraphConfigurations.GRAPH).map(Object::toString).ifPresent(arg_0 -> ((ArangoDBConfigurationBuilder)builder).graph(arg_0));
        settings.prefix((Supplier)ArangoDBGraphConfigurations.EDGE_RELATIONSHIP).stream().map(EdgeConfiguration::parse).forEach(e -> e.add(builder));
        return GraphFactory.open((Configuration)builder.build());
    }

    private static class EdgeConfiguration {
        private final String edge;
        private final String source;
        private final String target;

        private EdgeConfiguration(String source, String edge, String target) {
            this.edge = edge;
            this.source = source;
            this.target = target;
        }

        static EdgeConfiguration parse(Object value) {
            String[] values = value.toString().split("\\|");
            if (values.length != 3) {
                throw new IllegalArgumentException("The element is valid it must have three element split by pipe: " + value);
            }
            return new EdgeConfiguration(values[0], values[1], values[2]);
        }

        private void add(ArangoDBConfigurationBuilder builder) {
            builder.configureEdge(this.edge, this.source, this.target);
        }
    }
}

