/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.connections;

import com.steelbridgelabs.oss.neo4j.structure.Neo4JElementIdProvider;
import com.steelbridgelabs.oss.neo4j.structure.Neo4JGraph;
import com.steelbridgelabs.oss.neo4j.structure.providers.Neo4JNativeElementIdProvider;
import jakarta.nosql.Settings;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.eclipse.jnosql.mapping.graph.GraphConfiguration;
import org.eclipse.jnosql.mapping.graph.connections.Neo4JGraphConfigurations;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;

public class Neo4JGraphConfiguration
implements GraphConfiguration {
    public Graph apply(Settings settings) {
        Objects.requireNonNull(settings, "settings is required");
        String url = ((String)settings.getOrDefault(Neo4JGraphConfigurations.HOST.get(), (Object)"bolt://localhost:7687")).toString();
        String user = ((String)settings.getOrDefault(Neo4JGraphConfigurations.USER.get(), (Object)"neo4j")).toString();
        String password = ((String)settings.getOrDefault(Neo4JGraphConfigurations.PASSWORD.get(), (Object)"neo4j")).toString();
        AuthToken basic = AuthTokens.basic((String)user, (String)password);
        Driver driver = GraphDatabase.driver((String)url, (AuthToken)basic);
        Neo4JNativeElementIdProvider vertexIdProvider = new Neo4JNativeElementIdProvider();
        Neo4JNativeElementIdProvider edgeIdProvider = new Neo4JNativeElementIdProvider();
        return new Neo4JGraph(driver, (Neo4JElementIdProvider)vertexIdProvider, (Neo4JElementIdProvider)edgeIdProvider);
    }
}

