/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.MappingException;
import jakarta.nosql.mapping.column.ColumnEntityConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jnosql.mapping.column.ColumnFieldValue;
import org.eclipse.jnosql.mapping.column.DefaultColumnFieldValue;
import org.eclipse.jnosql.mapping.column.FieldConverter;
import org.eclipse.jnosql.mapping.column.ParameterConverter;
import org.eclipse.jnosql.mapping.reflection.ConstructorBuilder;
import org.eclipse.jnosql.mapping.reflection.ConstructorMetadata;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.FieldValue;
import org.eclipse.jnosql.mapping.reflection.InheritanceMetadata;
import org.eclipse.jnosql.mapping.reflection.MappingType;
import org.eclipse.jnosql.mapping.reflection.ParameterMetaData;

public abstract class AbstractColumnEntityConverter
implements ColumnEntityConverter {
    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    public ColumnEntity toColumn(Object entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().get(entity.getClass());
        ColumnEntity communication = ColumnEntity.of((String)mapping.getName());
        mapping.getFields().stream().map(f -> this.to((FieldMapping)f, entity)).filter(FieldValue::isNotEmpty).map(f -> f.toColumn(this, this.getConverters())).flatMap(Collection::stream).forEach(arg_0 -> ((ColumnEntity)communication).add(arg_0));
        mapping.getInheritance().ifPresent(i -> communication.add(i.getDiscriminatorColumn(), (Object)i.getDiscriminatorValue()));
        return communication;
    }

    public <T> T toEntity(Class<T> type, ColumnEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(type, "type is required");
        return this.toEntity(type, entity.getColumns());
    }

    public <T> T toEntity(T type, ColumnEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(type, "type is required");
        EntityMetadata mapping = this.getEntities().get(type.getClass());
        return this.convertEntity(entity.getColumns(), mapping, type);
    }

    public <T> T toEntity(ColumnEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().findByName(entity.getName());
        if (mapping.isInheritance()) {
            return this.mapInheritanceEntity(entity, mapping.getType());
        }
        ConstructorMetadata constructor = mapping.getConstructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(entity.getColumns(), mapping, instance);
        }
        return this.convertEntityByConstructor(entity.getColumns(), mapping);
    }

    protected ColumnFieldValue to(FieldMapping field, Object entity) {
        Object value = field.read(entity);
        return DefaultColumnFieldValue.of(value, field);
    }

    protected <T> Consumer<String> feedObject(T entity, List<Column> columns, Map<String, FieldMapping> fieldsGroupByName) {
        return k -> {
            Optional<Column> column = columns.stream().filter(c -> c.getName().equals(k)).findFirst();
            FieldMapping field = (FieldMapping)fieldsGroupByName.get(k);
            FieldConverter fieldConverter = FieldConverter.get(field);
            if (MappingType.ENTITY.equals((Object)field.getType())) {
                column.ifPresent(c -> fieldConverter.convert(entity, (Column)c, field, this));
            } else {
                fieldConverter.convert(entity, columns, column.orElse(null), field, this);
            }
        };
    }

    protected <T> T toEntity(Class<T> type, List<Column> columns) {
        EntityMetadata mapping = this.getEntities().get(type);
        if (mapping.isInheritance()) {
            return this.inheritanceToEntity(columns, mapping);
        }
        ConstructorMetadata constructor = mapping.getConstructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(columns, mapping, instance);
        }
        return this.convertEntityByConstructor(columns, mapping);
    }

    private <T> T convertEntityByConstructor(List<Column> columns, EntityMetadata mapping) {
        ConstructorBuilder builder = ConstructorBuilder.of((ConstructorMetadata)mapping.getConstructor());
        for (ParameterMetaData parameter : builder.getParameters()) {
            Optional<Column> column = columns.stream().filter(c -> c.getName().equals(parameter.getName())).findFirst();
            column.ifPresentOrElse(c -> {
                ParameterConverter converter = ParameterConverter.of(parameter);
                converter.convert(this, (Column)c, parameter, builder);
            }, () -> ((ConstructorBuilder)builder).addEmptyParameter());
        }
        return (T)builder.build();
    }

    private <T> T convertEntity(List<Column> columns, EntityMetadata mapping, T instance) {
        Map fieldsGroupByName = mapping.getFieldsGroupByName();
        List names = columns.stream().map(Column::getName).sorted().collect(Collectors.toList());
        Predicate<String> existField = k -> Collections.binarySearch(names, k) >= 0;
        Predicate<String> isElementType = k -> {
            MappingType type = ((FieldMapping)fieldsGroupByName.get(k)).getType();
            return MappingType.EMBEDDED.equals((Object)type) || MappingType.ENTITY.equals((Object)type);
        };
        fieldsGroupByName.keySet().stream().filter(existField.or(isElementType)).forEach(this.feedObject(instance, columns, fieldsGroupByName));
        return instance;
    }

    private <T> T mapInheritanceEntity(ColumnEntity entity, Class<?> type) {
        Map group = this.getEntities().findByParentGroupByDiscriminatorValue(type);
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the document collection " + entity.getName());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::getDiscriminatorColumn).orElseThrow();
        String discriminator = (String)entity.find(column, String.class).orElseThrow(() -> new MappingException("To inheritance there is the discriminator column missing on the Document Collection, the document name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata mapping = this.getEntities().get(inheritance.getEntity());
        ConstructorMetadata constructor = mapping.getConstructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(entity.getColumns(), mapping, instance);
        }
        return this.convertEntityByConstructor(entity.getColumns(), mapping);
    }

    private <T> T inheritanceToEntity(List<Column> columns, EntityMetadata mapping) {
        Map group = this.getEntities().findByParentGroupByDiscriminatorValue(mapping.getType());
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the document collection " + mapping.getName());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::getDiscriminatorColumn).orElseThrow();
        String discriminator = columns.stream().filter(d -> d.getName().equals(column)).findFirst().map(d -> (String)d.get(String.class)).orElseThrow(() -> new MappingException("To inheritance there is the discriminator column missing on the Document Collection, the document name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata inheritanceMetadata = this.getEntities().get(inheritance.getEntity());
        Object instance = inheritanceMetadata.newInstance();
        return (T)this.convertEntity(columns, inheritanceMetadata, instance);
    }
}

