/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.column.ColumnQueryParser;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.IdNotFoundException;
import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.PreparedStatement;
import jakarta.nosql.mapping.column.ColumnEntityConverter;
import jakarta.nosql.mapping.column.ColumnEventPersistManager;
import jakarta.nosql.mapping.column.ColumnQueryPagination;
import jakarta.nosql.mapping.column.ColumnTemplate;
import jakarta.nosql.mapping.column.ColumnWorkflow;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.mapping.column.ColumnMapperObserver;
import org.eclipse.jnosql.mapping.column.ColumnPage;
import org.eclipse.jnosql.mapping.column.ColumnPreparedStatement;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.util.ConverterUtil;

public abstract class AbstractColumnTemplate
implements ColumnTemplate {
    private static final ColumnQueryParser PARSER = (ColumnQueryParser)ServiceLoaderProvider.get(ColumnQueryParser.class, () -> ServiceLoader.load(ColumnQueryParser.class));
    private final UnaryOperator<ColumnEntity> insert = e -> this.getManager().insert(e);
    private final UnaryOperator<ColumnEntity> update = e -> this.getManager().update(e);
    private ColumnObserverParser observer;

    protected abstract ColumnEntityConverter getConverter();

    protected abstract ColumnManager getManager();

    protected abstract ColumnWorkflow getFlow();

    protected abstract ColumnEventPersistManager getEventManager();

    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    private ColumnObserverParser getObserver() {
        if (Objects.isNull(this.observer)) {
            this.observer = new ColumnMapperObserver(this.getEntities());
        }
        return this.observer;
    }

    public <T> T insert(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return (T)this.getFlow().flow(entity, this.insert);
    }

    public <T> T insert(T entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return (T)this.getFlow().flow(entity, e -> this.getManager().insert(e, ttl));
    }

    public <T> T update(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return (T)this.getFlow().flow(entity, this.update);
    }

    public <T> Iterable<T> update(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entity is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    public <T> Iterable<T> insert(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(e -> this.insert(e, ttl)).collect(Collectors.toList());
    }

    public void delete(ColumnDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.getEventManager().firePreDeleteQuery(query);
        this.getManager().delete(query);
    }

    public <T> Stream<T> select(ColumnQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.executeQuery(query);
    }

    public <T> Page<T> select(ColumnQueryPagination query) {
        Objects.requireNonNull(query, "query is required");
        Stream<T> entities = this.executeQuery((ColumnQuery)query);
        return new ColumnPage<T>(this, entities, query);
    }

    public <T> Optional<T> singleResult(ColumnQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<T> select = this.select(query);
        Iterator iterator = select.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No Unique result found to the query: " + query);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        FieldMapping idField = (FieldMapping)entityMetadata.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.getFieldName(), (Converters)this.getConverters());
        ColumnQuery query = ColumnQuery.select().from(entityMetadata.getName()).where(idField.getName()).eq(value).build();
        return this.singleResult(query);
    }

    public <T, K> void delete(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        FieldMapping idField = (FieldMapping)entityMetadata.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.getFieldName(), (Converters)this.getConverters());
        ColumnDeleteQuery query = ColumnDeleteQuery.delete().from(entityMetadata.getName()).where(idField.getName()).eq(value).build();
        this.getManager().delete(query);
    }

    public <T> Stream<T> query(String query) {
        Objects.requireNonNull(query, "query is required");
        return PARSER.query(query, this.getManager(), this.getObserver()).map(c -> this.getConverter().toEntity(c));
    }

    public <T> Optional<T> singleResult(String query) {
        Stream<T> entities = this.query(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No unique result found to the query: " + query);
    }

    public PreparedStatement prepare(String query) {
        return new ColumnPreparedStatement(PARSER.prepare(query, this.getManager(), this.getObserver()), this.getConverter());
    }

    public long count(String columnFamily) {
        return this.getManager().count(columnFamily);
    }

    public <T> long count(Class<T> type) {
        Objects.requireNonNull(type, "entity class is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        return this.getManager().count(entityMetadata.getName());
    }

    private <T> Stream<T> executeQuery(ColumnQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.getEventManager().firePreQuery(query);
        Stream entities = this.getManager().select(query);
        Function<ColumnEntity, Object> function = e -> this.getConverter().toEntity(e);
        return entities.map(function).peek(arg_0 -> ((ColumnEventPersistManager)this.getEventManager()).firePostEntity(arg_0));
    }
}

