/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.mapping.column.ColumnEntityConverter;
import jakarta.nosql.mapping.column.ColumnEventPersistManager;
import jakarta.nosql.mapping.column.ColumnWorkflow;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public abstract class AbstractColumnWorkflow
implements ColumnWorkflow {
    protected abstract ColumnEventPersistManager getEventManager();

    protected abstract ColumnEntityConverter getConverter();

    public <T> T flow(T entity, UnaryOperator<ColumnEntity> action) {
        Function<T, T> flow = this.getFlow(entity, action);
        return flow.apply(entity);
    }

    private <T> Function<T, T> getFlow(T entity, UnaryOperator<ColumnEntity> action) {
        UnaryOperator validation = t -> Objects.requireNonNull(t, "entity is required");
        UnaryOperator firePreEntity = t -> {
            this.getEventManager().firePreEntity(t);
            return t;
        };
        UnaryOperator firePreColumnEntity = t -> {
            this.getEventManager().firePreColumnEntity(t);
            return t;
        };
        Function<Object, ColumnEntity> converterColumn = t -> this.getConverter().toColumn(t);
        UnaryOperator firePreColumn = t -> {
            this.getEventManager().firePreColumn(t);
            return t;
        };
        UnaryOperator firePostColumn = t -> {
            this.getEventManager().firePostColumn(t);
            return t;
        };
        Function<ColumnEntity, Object> converterEntity = t -> this.getConverter().toEntity(entity, t);
        UnaryOperator firePostEntity = t -> {
            this.getEventManager().firePostEntity(t);
            return t;
        };
        UnaryOperator firePostColumnEntity = t -> {
            this.getEventManager().firePostColumnEntity(t);
            return t;
        };
        return validation.andThen(firePreEntity).andThen(firePreColumnEntity).andThen(converterColumn).andThen(firePreColumn).andThen(action).andThen(firePostColumn).andThen(converterEntity).andThen(firePostEntity).andThen(firePostColumnEntity);
    }
}

