/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.column.ColumnObserverParser;
import java.util.Optional;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

final class ColumnMapperObserver
implements ColumnObserverParser {
    private final EntitiesMetadata mappings;

    ColumnMapperObserver(EntitiesMetadata mappings) {
        this.mappings = mappings;
    }

    public String fireEntity(String entity) {
        Optional<EntityMetadata> mapping = this.getEntityMetadata(entity);
        return mapping.map(EntityMetadata::getName).orElse(entity);
    }

    public String fireField(String entity, String field) {
        Optional<EntityMetadata> mapping = this.getEntityMetadata(entity);
        return mapping.map(c -> c.getColumnField(field)).orElse(field);
    }

    private Optional<EntityMetadata> getEntityMetadata(String entity) {
        Optional bySimpleName = this.mappings.findBySimpleName(entity);
        if (bySimpleName.isPresent()) {
            return bySimpleName;
        }
        return this.mappings.findByClassName(entity);
    }
}

