/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.mapping.column.ColumnQueryPagination;
import jakarta.nosql.mapping.column.ColumnTemplate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ColumnPage<T>
implements Page<T> {
    private final ColumnTemplate template;
    private final Stream<T> entities;
    private final ColumnQueryPagination query;
    private List<T> entitiesCache;

    ColumnPage(ColumnTemplate template, Stream<T> entities, ColumnQueryPagination query) {
        this.template = template;
        this.entities = entities;
        this.query = query;
    }

    public Pagination getPagination() {
        return this.query.getPagination();
    }

    public Page<T> next() {
        return this.template.select(this.query.next());
    }

    public Stream<T> getContent() {
        return this.getEntities();
    }

    public <C extends Collection<T>> C getContent(Supplier<C> collectionFactory) {
        Objects.requireNonNull(collectionFactory, "collectionFactory is required");
        return (C)((Collection)this.getEntities().collect(Collectors.toCollection(collectionFactory)));
    }

    public Stream<T> get() {
        return this.getEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<T> getEntities() {
        if (Objects.isNull(this.entitiesCache)) {
            ColumnPage columnPage = this;
            synchronized (columnPage) {
                this.entitiesCache = this.entities.collect(Collectors.toList());
            }
        }
        return this.entitiesCache.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnPage that = (ColumnPage)o;
        return Objects.equals(this.entities, that.entities) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.entities, this.query);
    }

    public String toString() {
        return "ColumnPage{entities=" + this.entities + ", query=" + this.query + "}";
    }
}

