/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.mapping.EntityPostPersist;
import jakarta.nosql.mapping.EntityPrePersist;
import jakarta.nosql.mapping.column.ColumnDeleteQueryExecute;
import jakarta.nosql.mapping.column.ColumnEntityPostPersist;
import jakarta.nosql.mapping.column.ColumnEntityPrePersist;
import jakarta.nosql.mapping.column.ColumnEventPersistManager;
import jakarta.nosql.mapping.column.ColumnQueryExecute;
import jakarta.nosql.mapping.column.EntityColumnPostPersist;
import jakarta.nosql.mapping.column.EntityColumnPrePersist;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.DefaultEntityPostPersist;
import org.eclipse.jnosql.mapping.DefaultEntityPrePersist;
import org.eclipse.jnosql.mapping.column.DefaultColumnDeleteQueryExecute;
import org.eclipse.jnosql.mapping.column.DefaultColumnEntityPostPersist;
import org.eclipse.jnosql.mapping.column.DefaultColumnEntityPrePersist;
import org.eclipse.jnosql.mapping.column.DefaultColumnQueryExecute;
import org.eclipse.jnosql.mapping.column.DefaultEntityColumnPostPersist;
import org.eclipse.jnosql.mapping.column.DefaultEntityColumnPrePersist;

@ApplicationScoped
class DefaultColumnEventPersistManager
implements ColumnEventPersistManager {
    @Inject
    private Event<ColumnEntityPrePersist> columnEntityPrePersistEvent;
    @Inject
    private Event<ColumnEntityPostPersist> columnEntityPostPersistEvent;
    @Inject
    private Event<EntityPrePersist> entityPrePersistEvent;
    @Inject
    private Event<EntityPostPersist> entityPostPersistEvent;
    @Inject
    private Event<EntityColumnPrePersist> entityColumnPrePersist;
    @Inject
    private Event<EntityColumnPostPersist> entityColumnPostPersist;
    @Inject
    private Event<ColumnQueryExecute> columnQueryExecute;
    @Inject
    private Event<ColumnDeleteQueryExecute> columnDeleteQueryExecute;

    DefaultColumnEventPersistManager() {
    }

    public void firePreColumn(ColumnEntity entity) {
        this.columnEntityPrePersistEvent.fire((Object)new DefaultColumnEntityPrePersist(entity));
    }

    public void firePostColumn(ColumnEntity entity) {
        this.columnEntityPostPersistEvent.fire((Object)new DefaultColumnEntityPostPersist(entity));
    }

    public <T> void firePreEntity(T entity) {
        this.entityPrePersistEvent.fire((Object)new DefaultEntityPrePersist(entity));
    }

    public <T> void firePostEntity(T entity) {
        this.entityPostPersistEvent.fire((Object)new DefaultEntityPostPersist(entity));
    }

    public <T> void firePreColumnEntity(T entity) {
        this.entityColumnPrePersist.fire((Object)new DefaultEntityColumnPrePersist(entity));
    }

    public <T> void firePostColumnEntity(T entity) {
        this.entityColumnPostPersist.fire((Object)new DefaultEntityColumnPostPersist(entity));
    }

    public void firePreQuery(ColumnQuery query) {
        this.columnQueryExecute.fire((Object)new DefaultColumnQueryExecute(query));
    }

    public void firePreDeleteQuery(ColumnDeleteQuery query) {
        this.columnDeleteQueryExecute.fire((Object)new DefaultColumnDeleteQueryExecute(query));
    }
}

