/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.column.Column;
import jakarta.nosql.mapping.AttributeConverter;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.column.ColumnEntityConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jnosql.mapping.column.ColumnFieldValue;
import org.eclipse.jnosql.mapping.reflection.DefaultFieldValue;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.FieldValue;
import org.eclipse.jnosql.mapping.reflection.GenericFieldMapping;
import org.eclipse.jnosql.mapping.reflection.MappingType;

final class DefaultColumnFieldValue
implements ColumnFieldValue {
    private final FieldValue fieldValue;

    private DefaultColumnFieldValue(FieldValue fieldValue) {
        this.fieldValue = fieldValue;
    }

    public Object getValue() {
        return this.fieldValue.getValue();
    }

    public FieldMapping getField() {
        return this.fieldValue.getField();
    }

    public boolean isNotEmpty() {
        return this.fieldValue.isNotEmpty();
    }

    @Override
    public <X, Y> List<Column> toColumn(ColumnEntityConverter converter, Converters converters) {
        if (MappingType.EMBEDDED.equals((Object)this.getType())) {
            return converter.toColumn(this.getValue()).getColumns();
        }
        if (MappingType.ENTITY.equals((Object)this.getType())) {
            return Collections.singletonList(Column.of((String)this.getName(), (Object)converter.toColumn(this.getValue()).getColumns()));
        }
        if (this.isEmbeddableCollection()) {
            return Collections.singletonList(Column.of((String)this.getName(), this.getColumns(converter)));
        }
        Optional optionalConverter = this.getField().getConverter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((Class)optionalConverter.get());
            return Collections.singletonList(Column.of((String)this.getName(), (Object)attributeConverter.convertToDatabaseColumn(this.getValue())));
        }
        return Collections.singletonList(Column.of((String)this.getName(), (Object)this.getValue()));
    }

    private List<List<Column>> getColumns(ColumnEntityConverter converter) {
        ArrayList<List<Column>> columns = new ArrayList<List<Column>>();
        for (Object element : (Iterable)this.getValue()) {
            columns.add(converter.toColumn(element).getColumns());
        }
        return columns;
    }

    private boolean isEmbeddableCollection() {
        return MappingType.COLLECTION.equals((Object)this.getType()) && this.isEmbeddableElement();
    }

    private MappingType getType() {
        return this.getField().getType();
    }

    private String getName() {
        return this.getField().getName();
    }

    private boolean isEmbeddableElement() {
        return ((GenericFieldMapping)this.getField()).isEmbeddable();
    }

    public String toString() {
        return "ColumnFieldValue{fieldValue=" + this.fieldValue + "}";
    }

    static ColumnFieldValue of(Object value, FieldMapping field) {
        return new DefaultColumnFieldValue((FieldValue)new DefaultFieldValue(value, field));
    }
}

