/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.Sort;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.mapping.column.ColumnQueryPagination;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class DefaultColumnQueryPagination
implements ColumnQueryPagination {
    private final ColumnQuery query;
    private final Pagination pagination;

    DefaultColumnQueryPagination(ColumnQuery query, Pagination pagination) {
        this.query = query;
        this.pagination = pagination;
    }

    public long getLimit() {
        return this.pagination.getLimit();
    }

    public long getSkip() {
        return this.pagination.getSkip();
    }

    public String getColumnFamily() {
        return this.query.getColumnFamily();
    }

    public Optional<ColumnCondition> getCondition() {
        return this.query.getCondition();
    }

    public List<String> getColumns() {
        return this.query.getColumns();
    }

    public List<Sort> getSorts() {
        return this.query.getSorts();
    }

    public ColumnQueryPagination next() {
        return new DefaultColumnQueryPagination(this.query, this.pagination.next());
    }

    public Pagination getPagination() {
        return this.pagination.unmodifiable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultColumnQueryPagination that = (DefaultColumnQueryPagination)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.pagination, that.pagination);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.pagination);
    }

    public String toString() {
        return "DefaultColumnQueryPagination{query=" + this.query + ", pagination=" + this.pagination + "}";
    }
}

