/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.column.ColumnEntityConverter;
import jakarta.nosql.mapping.column.ColumnEventPersistManager;
import jakarta.nosql.mapping.column.ColumnTemplate;
import jakarta.nosql.mapping.column.ColumnTemplateProducer;
import jakarta.nosql.mapping.column.ColumnWorkflow;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.column.AbstractColumnTemplate;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;

@ApplicationScoped
class DefaultColumnTemplateProducer
implements ColumnTemplateProducer {
    @Inject
    private ColumnEntityConverter converter;
    @Inject
    private ColumnWorkflow columnWorkflow;
    @Inject
    private ColumnEventPersistManager eventManager;
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;

    DefaultColumnTemplateProducer() {
    }

    public ColumnTemplate get(ColumnManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return new ProducerColumnTemplate(this.converter, this.columnWorkflow, manager, this.eventManager, this.entities, this.converters);
    }

    @Vetoed
    static class ProducerColumnTemplate
    extends AbstractColumnTemplate {
        private ColumnEntityConverter converter;
        private ColumnWorkflow columnWorkflow;
        private ColumnManager manager;
        private ColumnEventPersistManager eventManager;
        private EntitiesMetadata entities;
        private Converters converters;

        ProducerColumnTemplate(ColumnEntityConverter converter, ColumnWorkflow columnWorkflow, ColumnManager manager, ColumnEventPersistManager eventManager, EntitiesMetadata entities, Converters converters) {
            this.converter = converter;
            this.columnWorkflow = columnWorkflow;
            this.manager = manager;
            this.eventManager = eventManager;
            this.entities = entities;
            this.converters = converters;
        }

        ProducerColumnTemplate() {
        }

        @Override
        protected ColumnEntityConverter getConverter() {
            return this.converter;
        }

        @Override
        protected ColumnManager getManager() {
            return this.manager;
        }

        @Override
        protected ColumnWorkflow getFlow() {
            return this.columnWorkflow;
        }

        @Override
        protected ColumnEventPersistManager getEventManager() {
            return this.eventManager;
        }

        @Override
        protected EntitiesMetadata getEntities() {
            return this.entities;
        }

        @Override
        protected Converters getConverters() {
            return this.converters;
        }
    }
}

