/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.TypeReference;
import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.column.Column;
import jakarta.nosql.mapping.AttributeConverter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.mapping.column.AbstractColumnEntityConverter;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.GenericFieldMapping;
import org.eclipse.jnosql.mapping.reflection.MappingType;

enum FieldConverter {
    EMBEDDED{

        @Override
        public <X, Y, T> void convert(T instance, List<Column> columns, Column column, FieldMapping field, AbstractColumnEntityConverter converter) {
            Field nativeField = field.getNativeField();
            Object subEntity = converter.toEntity(nativeField.getType(), columns);
            EntityMetadata mapping = converter.getEntities().get(subEntity.getClass());
            boolean areAllFieldsNull = mapping.getFields().stream().map(f -> f.read(subEntity)).allMatch(Objects::isNull);
            if (!areAllFieldsNull) {
                field.write(instance, subEntity);
            }
        }
    }
    ,
    ENTITY{

        @Override
        public <X, Y, T> void convert(T instance, List<Column> columns, Column subColumn, FieldMapping field, AbstractColumnEntityConverter converter) {
            if (Objects.nonNull(subColumn)) {
                this.converterSubDocument(instance, subColumn, field, converter);
            } else {
                field.write(instance, converter.toEntity(field.getNativeField().getType(), columns));
            }
        }

        private <T> void converterSubDocument(T instance, Column subColumn, FieldMapping field, AbstractColumnEntityConverter converter) {
            Object value = subColumn.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Column> embeddedColumns = new ArrayList<Column>();
                for (Map.Entry entry : map.entrySet()) {
                    embeddedColumns.add(Column.of((String)entry.getKey().toString(), entry.getValue()));
                }
                field.write(instance, converter.toEntity(field.getNativeField().getType(), embeddedColumns));
            } else {
                field.write(instance, converter.toEntity(field.getNativeField().getType(), (List)subColumn.get((TypeSupplier)new TypeReference<List<Column>>(){})));
            }
        }
    }
    ,
    COLLECTION{

        @Override
        public <X, Y, T> void convert(T instance, List<Column> columns, Column column, FieldMapping field, AbstractColumnEntityConverter converter) {
            if (Objects.nonNull(column)) {
                GenericFieldMapping genericField = (GenericFieldMapping)field;
                Collection elements = genericField.getCollectionInstance();
                List embeddable = (List)column.get();
                for (List columnList : embeddable) {
                    Object element = converter.toEntity(genericField.getElementType(), columnList);
                    elements.add(element);
                }
                field.write(instance, (Object)elements);
            }
        }
    }
    ,
    DEFAULT{

        @Override
        public <X, Y, T> void convert(T instance, List<Column> columns, Column column, FieldMapping field, AbstractColumnEntityConverter converter) {
            if (Objects.nonNull(column)) {
                Value value = column.getValue();
                Optional optionalConverter = field.getConverter();
                if (optionalConverter.isPresent()) {
                    AttributeConverter attributeConverter = converter.getConverters().get((Class)optionalConverter.get());
                    Object attributeConverted = attributeConverter.convertToEntityAttribute(value.get());
                    field.write(instance, field.getValue(Value.of((Object)attributeConverted)));
                } else {
                    field.write(instance, field.getValue(value));
                }
            }
        }
    };


    static FieldConverter get(FieldMapping field) {
        if (MappingType.EMBEDDED.equals((Object)field.getType())) {
            return EMBEDDED;
        }
        if (MappingType.ENTITY.equals((Object)field.getType())) {
            return ENTITY;
        }
        if (FieldConverter.isCollectionEmbeddable(field)) {
            return COLLECTION;
        }
        return DEFAULT;
    }

    private static boolean isCollectionEmbeddable(FieldMapping field) {
        return MappingType.COLLECTION.equals((Object)field.getType()) && ((GenericFieldMapping)field).isEmbeddable();
    }

    abstract <X, Y, T> void convert(T var1, List<Column> var2, Column var3, FieldMapping var4, AbstractColumnEntityConverter var5);

    <X, Y, T> void convert(T instance, Column column, FieldMapping field, AbstractColumnEntityConverter converter) {
        this.convert(instance, null, column, field, converter);
    }
}

