/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column;

import jakarta.nosql.TypeReference;
import jakarta.nosql.TypeSupplier;
import jakarta.nosql.column.Column;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jnosql.mapping.column.AbstractColumnEntityConverter;
import org.eclipse.jnosql.mapping.reflection.ConstructorBuilder;
import org.eclipse.jnosql.mapping.reflection.GenericParameterMetaData;
import org.eclipse.jnosql.mapping.reflection.ParameterMetaData;

enum ParameterConverter {
    DEFAULT{

        @Override
        void convert(AbstractColumnEntityConverter converter, Column column, ParameterMetaData parameterMetaData, ConstructorBuilder builder) {
            parameterMetaData.getConverter().ifPresentOrElse(c -> {
                Object value = converter.getConverters().get(c).convertToEntityAttribute(column.get());
                builder.add(value);
            }, () -> builder.add(column.get()));
        }
    }
    ,
    ENTITY{

        @Override
        void convert(AbstractColumnEntityConverter converter, Column column, ParameterMetaData parameterMetaData, ConstructorBuilder builder) {
            Object value = column.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Column> columns = new ArrayList<Column>();
                for (Map.Entry entry : map.entrySet()) {
                    columns.add(Column.of((String)entry.getKey().toString(), entry.getValue()));
                }
                Object entity = converter.toEntity(parameterMetaData.getType(), columns);
                builder.add(entity);
            } else {
                List columns = (List)column.get((TypeSupplier)new TypeReference<List<Column>>(){});
                Object entity = converter.toEntity(parameterMetaData.getType(), columns);
                builder.add(entity);
            }
        }
    }
    ,
    COLLECTION{

        @Override
        void convert(AbstractColumnEntityConverter converter, Column column, ParameterMetaData parameterMetaData, ConstructorBuilder builder) {
            GenericParameterMetaData genericParameter = (GenericParameterMetaData)parameterMetaData;
            Collection elements = genericParameter.getCollectionInstance();
            List embeddable = (List)column.get();
            for (List columnList : embeddable) {
                Object element = converter.toEntity(genericParameter.getElementType(), columnList);
                elements.add(element);
            }
            builder.add((Object)elements);
        }
    };


    abstract void convert(AbstractColumnEntityConverter var1, Column var2, ParameterMetaData var3, ConstructorBuilder var4);

    static ParameterConverter of(ParameterMetaData parameter) {
        switch (parameter.getParamType()) {
            case COLLECTION: {
                return COLLECTION;
            }
            case ENTITY: {
                return ENTITY;
            }
        }
        return DEFAULT;
    }
}

