/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.configuration;

import jakarta.nosql.column.ColumnConfiguration;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnManagerFactory;
import jakarta.nosql.mapping.MappingException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.jnosql.mapping.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.config.MicroProfileSettings;
import org.eclipse.jnosql.mapping.reflection.Reflections;

@ApplicationScoped
class ColumnManagerSupplier
implements Supplier<ColumnManager> {
    private static final Logger LOGGER = Logger.getLogger(ColumnManagerSupplier.class.getName());

    ColumnManagerSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    public ColumnManager get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        ColumnConfiguration configuration = settings.get((Supplier)MappingConfigurations.COLUMN_PROVIDER, Class.class).filter(ColumnConfiguration.class::isAssignableFrom).map(c -> {
            Reflections reflections = (Reflections)CDI.current().select(Reflections.class, new Annotation[0]).get();
            return (ColumnConfiguration)reflections.newInstance(c);
        }).orElseGet(ColumnConfiguration::getConfiguration);
        ColumnManagerFactory managerFactory = (ColumnManagerFactory)configuration.apply((Object)settings);
        Optional database = settings.get((Supplier)MappingConfigurations.COLUMN_DATABASE, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + MappingConfigurations.COLUMN_DATABASE));
        ColumnManager manager = (ColumnManager)managerFactory.apply((Object)db);
        LOGGER.log(Level.FINEST, "Starting  a ColumnManager instance using Eclipse MicroProfile Config, database name: " + db);
        return manager;
    }

    public void close(@Disposes ColumnManager manager) {
        LOGGER.log(Level.FINEST, "Closing ColumnManager resource, database name: " + manager.getName());
        manager.close();
    }
}

