/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Repository;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.eclipse.jnosql.mapping.column.query.BaseColumnRepository;
import org.eclipse.jnosql.mapping.query.RepositoryType;
import org.eclipse.jnosql.mapping.repository.DynamicQueryMethodReturn;

public abstract class AbstractColumnRepositoryProxy<T, K>
extends BaseColumnRepository
implements InvocationHandler {
    protected abstract Repository getRepository();

    @Override
    protected abstract Converters getConverters();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        Class typeClass = this.getEntityMetadata().getType();
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                ColumnQuery query = this.getQuery(method, args);
                return this.executeQuery(method, args, typeClass, query);
            }
            case FIND_ALL: {
                ColumnQuery queryFindAll = ColumnQuery.select().from(this.getEntityMetadata().getName()).build();
                return this.executeQuery(method, args, typeClass, this.getQuerySorts(args, queryFindAll));
            }
            case DELETE_BY: {
                ColumnDeleteQuery deleteQuery = this.getDeleteQuery(method, args);
                this.getTemplate().delete(deleteQuery);
                return Void.class;
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().withArgs(args).withMethod(method).withTypeClass(typeClass).withPrepareConverter(q -> this.getTemplate().prepare(q)).withQueryConverter(q -> this.getTemplate().query(q)).build();
                return methodReturn.execute();
            }
        }
        return Void.class;
    }
}

