/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.mapping.Converters;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.util.ConverterUtil;

abstract class AbstractMapperQuery {
    protected final String columnFamily;
    protected boolean negate;
    protected ColumnCondition condition;
    protected boolean and;
    protected String name;
    protected final EntityMetadata mapping;
    protected final Converters converters;
    protected long start;
    protected long limit;

    AbstractMapperQuery(EntityMetadata mapping, Converters converters) {
        this.mapping = mapping;
        this.converters = converters;
        this.columnFamily = mapping.getName();
    }

    protected void appendCondition(ColumnCondition newCondition) {
        ColumnCondition columnCondition = this.getColumnCondition(newCondition);
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(columnCondition) : this.condition.or(columnCondition)) : columnCondition;
        this.negate = false;
        this.name = null;
    }

    protected <T> void betweenImpl(T valueA, T valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        ColumnCondition newCondition = ColumnCondition.between((Column)Column.of((String)this.mapping.getColumnField(this.name), Arrays.asList(this.getValue(valueA), this.getValue(valueB))));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        List convertedValues = StreamSupport.stream(values.spliterator(), false).map(this::getValue).collect(Collectors.toList());
        ColumnCondition newCondition = ColumnCondition.in((Column)Column.of((String)this.mapping.getColumnField(this.name), convertedValues));
        this.appendCondition(newCondition);
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.eq((Column)Column.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.like((Column)Column.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.gte((Column)Column.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.gt((Column)Column.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.lt((Column)Column.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.lte((Column)Column.of((String)this.mapping.getColumnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected Object getValue(Object value) {
        return ConverterUtil.getValue((Object)value, (EntityMetadata)this.mapping, (String)this.name, (Converters)this.converters);
    }

    private ColumnCondition getColumnCondition(ColumnCondition newCondition) {
        if (this.negate) {
            return newCondition.negate();
        }
        return newCondition;
    }
}

